/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import java.util.Enumeration;
import java.util.Hashtable;

class IndoubtStateHandler
extends CoordinatorStateHandler {
    private int inquiries_ = 0;
    private boolean recovered_ = false;

    IndoubtStateHandler(CoordinatorImp coordinatorImp) {
        super(coordinatorImp);
    }

    IndoubtStateHandler(CoordinatorStateHandler coordinatorStateHandler) {
        super(coordinatorStateHandler);
    }

    protected void recover(CoordinatorImp coordinatorImp) {
        super.recover(coordinatorImp);
        if (this.getCoordinator().getState().equals(TxState.COMMITTING)) {
            Object object;
            Enumeration enumeration = this.getCoordinator().getParticipants().keys();
            Hashtable<Object, TxState> hashtable = new Hashtable<Object, TxState>();
            while (enumeration.hasMoreElements()) {
                object = (Participant)enumeration.nextElement();
                if (this.getReadOnlyTable().containsKey(object)) continue;
                this.addToHeuristicMap((Participant)object, TxState.HEUR_HAZARD);
                hashtable.put(object, TxState.HEUR_HAZARD);
            }
            object = new HeurHazardStateHandler(this, hashtable);
            this.getCoordinator().setStateHandler((CoordinatorStateHandler)object);
            ((HeurHazardStateHandler)object).recover(coordinatorImp);
        }
        this.recovered_ = true;
    }

    protected Object getState() {
        return TxState.IN_DOUBT;
    }

    protected void onTimeout() {
        if (!this.getCoordinator().getState().equals(this.getState())) {
            return;
        }
        try {
            if ((long)this.inquiries_ < this.getCoordinator().getMaxIndoubtTicks()) {
                ++this.inquiries_;
                if ((long)this.inquiries_ >= this.getCoordinator().getMaxIndoubtTicks() / 2L && this.getCoordinator().getSuperiorRecoveryCoordinator() != null) {
                    this.printMsg("Requesting replayCompletion on behalf of coordinator " + this.getCoordinator().getCoordinatorId(), 2);
                    this.getCoordinator().getSuperiorRecoveryCoordinator().replayCompletion((Participant)this.getCoordinator());
                }
            } else if (this.getCoordinator().getSuperiorRecoveryCoordinator() == null) {
                this.rollback(true, !this.recovered_);
            } else if (this.getCoordinator().prefersHeuristicCommit()) {
                this.commit(true, false);
            } else {
                this.rollback(true, true);
            }
        }
        catch (Exception exception) {
            this.printMsg("Error in timeout of INDOUBT state: " + exception.getMessage());
        }
    }

    protected void setGlobalSiblingCount(int n) {
    }

    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        return 1;
    }

    protected HeuristicMessage[] commit(boolean bl) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        return this.commit(false, false);
    }

    protected HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        return this.rollback(true, false);
    }
}

