/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.jmx;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransactionMBean;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class JmxTransaction
implements JmxTransactionMBean,
MBeanRegistration {
    private AdminTransaction adminTransaction;
    private MBeanServer server;
    private ObjectName name;

    protected static String convertState(int n) {
        String string = "UNKNOWN";
        switch (n) {
            case -3: {
                string = "ACTIVE";
                break;
            }
            case -2: {
                string = "PREPARING";
                break;
            }
            case 0: {
                string = "PREPARED";
                break;
            }
            case 4: {
                string = "HEURISTIC MIXED";
                break;
            }
            case 3: {
                string = "HEURISTIC HAZARD";
                break;
            }
            case 1: {
                string = "HEURISTIC COMMIT";
                break;
            }
            case 2: {
                string = "HEURISTIC ROLLBACK";
                break;
            }
            case 6: {
                string = "COMMITTING";
                break;
            }
            case 5: {
                string = "ROLLING BACK";
                break;
            }
            case 7: {
                string = "TERMINATED";
                break;
            }
        }
        return string;
    }

    protected static String[] convertHeuristicMessages(HeuristicMessage[] heuristicMessageArray) {
        String[] stringArray = new String[heuristicMessageArray.length];
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            stringArray[i] = heuristicMessageArray[i] != null ? heuristicMessageArray[i].toString() : "";
        }
        return stringArray;
    }

    public JmxTransaction(AdminTransaction adminTransaction) {
        this.adminTransaction = adminTransaction;
    }

    protected AdminTransaction getAdminTransaction() {
        return this.adminTransaction;
    }

    protected void unregister() {
        try {
            if (this.server.isRegistered(this.name)) {
                this.server.unregisterMBean(this.name);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getTid() {
        return this.adminTransaction.getTid();
    }

    public String getState() {
        return JmxTransaction.convertState(this.adminTransaction.getState());
    }

    public String[] getTags() {
        return JmxTransaction.convertHeuristicMessages(this.adminTransaction.getTags());
    }

    public String[] getHeuristicMessages() {
        return JmxTransaction.convertHeuristicMessages(this.adminTransaction.getHeuristicMessages());
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        if (objectName == null) {
            objectName = new ObjectName("atomikos.transactions", "TID", this.getTid());
        }
        this.name = objectName;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

