/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosJMSException;
import com.atomikos.jms.AtomikosTransactionRequiredJMSException;
import javax.jms.JMSException;

abstract class ConsumerProducerSupport {
    private SessionHandleState state;

    protected ConsumerProducerSupport(SessionHandleState state) {
        this.state = state;
    }

    protected void handleException(Exception e) throws AtomikosJMSException {
        this.state.notifySessionErrorOccurred();
        AtomikosJMSException.throwAtomikosJMSException("Error in proxy", e);
    }

    protected CompositeTransactionManager getCompositeTransactionManager() {
        CompositeTransactionManager ret = null;
        ret = Configuration.getCompositeTransactionManager();
        return ret;
    }

    protected void enlist(String hmsg) throws JMSException {
        CompositeTransaction ct = null;
        CompositeTransactionManager ctm = this.getCompositeTransactionManager();
        boolean enlist = false;
        StringHeuristicMessage shmsg = new StringHeuristicMessage(hmsg);
        if (ctm != null && (ct = ctm.getCompositeTransaction()) != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            enlist = true;
        }
        if (enlist) {
            this.registerSynchronization(ct);
            try {
                this.state.notifyBeforeUse(ct, shmsg);
            }
            catch (InvalidSessionHandleStateException ex) {
                String msg = "error during enlist: " + ex.getMessage();
                Configuration.logWarning(this + ": " + msg);
                AtomikosJMSException.throwAtomikosJMSException(msg, ex);
            }
        } else {
            String msg = "The JMS session you are using requires a JTA transaction context for the calling thread and none was found.\nPlease correct your code to do one of the following: \n1. start a JTA transaction if you want your JMS operations to be subject to JTA commit/rollback, or\n2. increase the maxPoolSize of the AtomikosConnectionFactoryBean to avoid transaction timeout while waiting for a connection, or\n3. create a non-transacted session and do session acknowledgment yourself, or\n4. set localTransactionMode to true so connection-level commit/rollback are enabled.";
            Configuration.logWarning(this + ": " + msg);
            AtomikosTransactionRequiredJMSException.throwAtomikosTransactionRequiredJMSException(msg);
        }
    }

    private void registerSynchronization(CompositeTransaction ct) throws AtomikosJMSException {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": detected transaction " + ct);
        }
        ct.registerSynchronization(new JmsRequeueSynchronization(ct));
    }

    private class JmsRequeueSynchronization
    implements Synchronization {
        private static final long serialVersionUID = 1L;
        private CompositeTransaction compositeTransaction;
        private boolean afterCompletionDone;

        public JmsRequeueSynchronization(CompositeTransaction compositeTransaction) {
            this.compositeTransaction = compositeTransaction;
            this.afterCompletionDone = false;
        }

        public void afterCompletion(Object txstate) {
            if (this.afterCompletionDone) {
                return;
            }
            if (txstate.equals(TxState.TERMINATED) || txstate.equals(TxState.HEUR_MIXED) || txstate.equals(TxState.HEUR_HAZARD) || txstate.equals(TxState.HEUR_ABORTED) || txstate.equals(TxState.HEUR_COMMITTED)) {
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug("JmsRequeueSynchronization: detected termination of transaction " + this.compositeTransaction);
                }
                ConsumerProducerSupport.this.state.notifyTransactionTerminated(this.compositeTransaction);
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug("JmsRequeueSynchronization: is in terminated state ? " + ConsumerProducerSupport.this.state.isTerminated());
                }
                this.afterCompletionDone = true;
            }
        }

        public void beforeCompletion() {
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof JmsRequeueSynchronization) {
                JmsRequeueSynchronization o = (JmsRequeueSynchronization)other;
                ret = this.compositeTransaction.isSameTransaction(o.compositeTransaction);
            }
            return ret;
        }

        public int hashCode() {
            return this.compositeTransaction.hashCode();
        }
    }
}

