/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.util.IntraVmObjectFactory;
import com.atomikos.util.IntraVmObjectRegistry;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public abstract class AbstractDataSourceBean
implements HeuristicDataSource,
ConnectionPoolProperties,
Referenceable,
Serializable {
    static final int DEFAULT_ISOLATION_LEVEL_UNSET = -1;
    static final int DEFAULT_POOL_SIZE = 1;
    private int minPoolSize = 1;
    private int maxPoolSize = 1;
    private int borrowConnectionTimeout = 30;
    private int reapTimeout = 0;
    private int maxIdleTime = 60;
    private String testQuery;
    private int maintenanceInterval = 60;
    private int loginTimeout;
    private transient ConnectionPool connectionPool;
    private transient PrintWriter logWriter;
    private String resourceName;
    private int defaultIsolationLevel = -1;

    protected void throwAtomikosSQLException(String msg) throws AtomikosSQLException {
        this.throwAtomikosSQLException(msg, null);
    }

    protected void throwAtomikosSQLException(String msg, Throwable cause) throws AtomikosSQLException {
        AtomikosSQLException.throwAtomikosSQLException(msg, cause);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setPoolSize(int poolSize) {
        this.minPoolSize = poolSize;
        this.maxPoolSize = poolSize;
    }

    public int getBorrowConnectionTimeout() {
        return this.borrowConnectionTimeout;
    }

    public void setBorrowConnectionTimeout(int borrowConnectionTimeout) {
        this.borrowConnectionTimeout = borrowConnectionTimeout;
    }

    public int getReapTimeout() {
        return this.reapTimeout;
    }

    public void setReapTimeout(int reapTimeout) {
        this.reapTimeout = reapTimeout;
    }

    public void setMaintenanceInterval(int maintenanceInterval) {
        this.maintenanceInterval = maintenanceInterval;
    }

    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public int poolAvailableSize() {
        return this.connectionPool.availableSize();
    }

    public int poolTotalSize() {
        return this.connectionPool.totalSize();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public synchronized void init() throws AtomikosSQLException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": init...");
        }
        if (this.connectionPool != null) {
            return;
        }
        if (this.maxPoolSize < 1) {
            this.throwAtomikosSQLException("Property 'maxPoolSize' must be greater than 0, was: " + this.maxPoolSize);
        }
        if (this.minPoolSize < 0 || this.minPoolSize > this.maxPoolSize) {
            this.throwAtomikosSQLException("Property 'minPoolSize' must be at least 0 and at most maxPoolSize, was: " + this.minPoolSize);
        }
        if (this.getUniqueResourceName() == null) {
            this.throwAtomikosSQLException("Property 'uniqueResourceName' cannot be null");
        }
        if (this.getTestQuery() == null) {
            Configuration.logWarning(this + ": no testQuery set - the connection pool will not be able to validate the connections!");
        }
        if (this.getMinPoolSize() == 1) {
            Configuration.logWarning(this + ": poolSize equals default - this may cause performance problems!");
        }
        try {
            this.getReference();
            ConnectionFactory cf = this.doInit();
            this.connectionPool = new ConnectionPool(cf, this);
        }
        catch (AtomikosSQLException e) {
            throw e;
        }
        catch (Exception ex) {
            String msg = "Cannot initialize AtomikosDataSourceBean";
            AtomikosSQLException.throwAtomikosSQLException(msg, ex);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": init done.");
        }
    }

    public void close() {
        block5: {
            if (Configuration.isInfoLoggingEnabled()) {
                Configuration.logInfo(this + ": close...");
            }
            if (this.connectionPool != null) {
                this.connectionPool.destroy();
            }
            this.connectionPool = null;
            this.doClose();
            try {
                IntraVmObjectRegistry.removeResource(this.getUniqueResourceName());
            }
            catch (NameNotFoundException e) {
                if (!Configuration.isDebugLoggingEnabled()) break block5;
                Configuration.logDebug(this + ": Error removing from JNDI", e);
            }
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": close done.");
        }
    }

    protected abstract ConnectionFactory doInit() throws Exception;

    protected abstract void doClose();

    public Connection getConnection(HeuristicMessage msg) throws SQLException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo(this + ": getConnection ( " + msg + " )...");
        }
        Connection connection = null;
        this.init();
        try {
            connection = (Connection)((Object)this.connectionPool.borrowConnection(msg));
        }
        catch (CreateConnectionException ex) {
            this.throwAtomikosSQLException("Failed to grow the connection pool", ex);
        }
        catch (PoolExhaustedException e) {
            this.throwAtomikosSQLException("Connection pool exhausted - try increasing 'maxPoolSize' and/or 'borrowConnectionTimeout' on the DataSourceBean.");
        }
        catch (ConnectionPoolException e) {
            this.throwAtomikosSQLException("Error borrowing connection", e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": returning " + connection);
        }
        return connection;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Configuration.logWarning(this + ": getConnection ( user , password ) ignores authentication - returning default connection");
        return this.getConnection();
    }

    public String getUniqueResourceName() {
        return this.resourceName;
    }

    public void setUniqueResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean getLocalTransactionMode() {
        return true;
    }

    public Reference getReference() throws NamingException {
        return IntraVmObjectFactory.createReference(this, this.getUniqueResourceName());
    }

    public Connection getConnection() throws SQLException {
        HeuristicMessage m = null;
        return this.getConnection(m);
    }

    public Connection getConnection(String msg) throws SQLException {
        return this.getConnection(new StringHeuristicMessage(msg));
    }

    public Connection getConnection(String user, String passwd, String msg) throws SQLException {
        Configuration.logWarning(this + ": getConnection ( user , password , msg ) ignores authentication - returning default connection");
        return this.getConnection(msg);
    }

    public Connection getConnection(String user, String passwd, HeuristicMessage msg) throws SQLException {
        Configuration.logWarning(this + ": getConnection ( user , password , msg ) ignores authentication - returning default connection");
        return this.getConnection(msg);
    }

    public void setDefaultIsolationLevel(int defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }
}

