/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.Recoverable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

class CoordinatorLogImage
implements ObjectImage {
    static final long serialVersionUID = 3404629869531420208L;
    String root_;
    TxState state_;
    boolean heuristicCommit_;
    Vector participants_;
    RecoveryCoordinator coordinator_;
    long maxInquiries_;
    CoordinatorStateHandler stateHandler_;
    boolean activity_;
    int localSiblingCount_;
    boolean checkSiblings_;
    boolean single_threaded_2pc_;

    public CoordinatorLogImage() {
    }

    public CoordinatorLogImage(String root, TxState state, Vector participants, RecoveryCoordinator coordinator, boolean commit_on_heuristic, long maxinquiries, CoordinatorStateHandler stateHandler, boolean single_threaded_2pc) {
        this.root_ = root;
        this.state_ = state;
        this.participants_ = participants;
        this.coordinator_ = coordinator;
        this.heuristicCommit_ = commit_on_heuristic;
        this.maxInquiries_ = maxinquiries;
        this.stateHandler_ = stateHandler;
        this.activity_ = false;
        this.localSiblingCount_ = 0;
        this.checkSiblings_ = false;
        this.single_threaded_2pc_ = single_threaded_2pc;
    }

    public CoordinatorLogImage(String root, TxState state, Vector participants, RecoveryCoordinator coordinator, boolean commit_on_heuristic, long maxinquiries, CoordinatorStateHandler stateHandler, int localSiblingCount, boolean checkSiblings, boolean single_threaded_2pc) {
        this(root, state, participants, coordinator, commit_on_heuristic, maxinquiries, stateHandler, single_threaded_2pc);
        this.activity_ = true;
        this.localSiblingCount_ = localSiblingCount;
        this.checkSiblings_ = checkSiblings;
    }

    public Object getId() {
        return this.root_;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.root_);
        out.writeObject(this.state_);
        out.writeObject(this.participants_.clone());
        if (this.coordinator_ == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.coordinator_);
        }
        out.writeBoolean(this.heuristicCommit_);
        out.writeLong(this.maxInquiries_);
        out.writeObject(this.stateHandler_.clone());
        out.writeBoolean(this.activity_);
        if (this.activity_) {
            out.writeInt(this.localSiblingCount_);
            out.writeBoolean(this.checkSiblings_);
        }
        out.writeBoolean(this.single_threaded_2pc_);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.root_ = (String)in.readObject();
            this.state_ = (TxState)in.readObject();
            this.participants_ = (Vector)in.readObject();
            boolean readcoord = in.readBoolean();
            if (readcoord) {
                this.coordinator_ = (RecoveryCoordinator)in.readObject();
            }
            this.heuristicCommit_ = in.readBoolean();
            this.maxInquiries_ = in.readLong();
            this.stateHandler_ = (CoordinatorStateHandler)in.readObject();
            this.activity_ = in.readBoolean();
            if (this.activity_) {
                this.localSiblingCount_ = in.readInt();
                this.checkSiblings_ = in.readBoolean();
            }
            this.single_threaded_2pc_ = in.readBoolean();
        }
        catch (InvalidClassException ex) {
            throw (IOException)new IOException("Object of class " + ex.classname + " in transaction log" + " not compatible with version found in classpath").initCause(ex);
        }
    }

    public Recoverable restore() {
        CoordinatorImp coord = new CoordinatorImp();
        coord.restore(this);
        return coord;
    }
}

