/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class Sync2Sync
implements Synchronization {
    private static final Logger LOGGER = LoggerFactory.createLogger(Sync2Sync.class);
    protected javax.transaction.Synchronization sync;
    private Boolean committed;

    Sync2Sync(javax.transaction.Synchronization sync) {
        this.sync = sync;
    }

    public void beforeCompletion() {
        this.sync.beforeCompletion();
        this.resetForReuse();
        LOGGER.logInfo("beforeCompletion() called on Synchronization: " + this.sync.toString());
    }

    private void resetForReuse() {
        this.committed = null;
    }

    public void afterCompletion(TxState state) {
        if (state.equals((Object)TxState.TERMINATED)) {
            if (this.committed == null) {
                this.sync.afterCompletion(5);
                LOGGER.logInfo("afterCompletion ( STATUS_UNKNOWN ) called  on Synchronization: " + this.sync.toString());
            } else {
                boolean commit = this.committed;
                if (commit) {
                    this.sync.afterCompletion(3);
                    LOGGER.logInfo("afterCompletion ( STATUS_COMMITTED ) called  on Synchronization: " + this.sync.toString());
                } else {
                    this.sync.afterCompletion(4);
                    LOGGER.logInfo("afterCompletion ( STATUS_ROLLEDBACK ) called  on Synchronization: " + this.sync.toString());
                }
            }
        } else if (state.equals((Object)TxState.COMMITTING)) {
            this.committed = new Boolean(true);
        } else if (state.equals((Object)TxState.ABORTING)) {
            this.committed = new Boolean(false);
        }
    }
}

