/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SiblingMapper {
    protected Map<CompositeTransaction, List<XAResourceTransaction>> siblingsOfSameRoot = new HashMap<CompositeTransaction, List<XAResourceTransaction>>();
    protected XATransactionalResource res;
    protected String root;

    SiblingMapper(XATransactionalResource res, String root) {
        this.res = res;
        this.root = root;
    }

    private XAResourceTransaction findSiblingBranchToJoin(CompositeTransaction ct) {
        XAResourceTransaction ret = null;
        if (ct.isSerial()) {
            Iterator<List<XAResourceTransaction>> allSiblingLists = this.siblingsOfSameRoot.values().iterator();
            while (ret == null && allSiblingLists.hasNext()) {
                List<XAResourceTransaction> siblings = allSiblingLists.next();
                ret = this.findJoinableBranchInList(siblings);
            }
        }
        return ret;
    }

    private XAResourceTransaction findJoinableBranchInList(List<XAResourceTransaction> siblings) {
        XAResourceTransaction ret = null;
        Iterator<XAResourceTransaction> it = siblings.iterator();
        while (ret == null && it.hasNext()) {
            XAResourceTransaction candidate = it.next();
            if (!candidate.supportsTmJoin()) continue;
            ret = candidate;
        }
        return ret;
    }

    protected synchronized ResourceTransaction findOrCreateBranchForTransaction(CompositeTransaction ct) throws ResourceException, IllegalStateException {
        XAResourceTransaction ret = this.findOrCreateBranchWithResourceException(ct);
        ct.addParticipant((Participant)ret);
        return ret;
    }

    private XAResourceTransaction findOrCreateBranchWithResourceException(CompositeTransaction ct) {
        XAResourceTransaction ret = null;
        try {
            ret = this.findOrCreateBranch(ct);
        }
        catch (Exception e) {
            throw new ResourceException("Failed to get branch", (Throwable)e);
        }
        return ret;
    }

    private XAResourceTransaction findOrCreateBranch(CompositeTransaction ct) {
        XAResourceTransaction ret = this.findPreviousBranchToJoin(ct);
        if (ret == null && (ret = this.findSiblingBranchToJoin(ct)) == null) {
            ret = this.createNewBranch(ct);
        }
        return ret;
    }

    private XAResourceTransaction createNewBranch(CompositeTransaction ct) {
        XAResourceTransaction ret = new XAResourceTransaction(this.res, ct, this.root);
        this.rememberBranch(ct, ret);
        return ret;
    }

    private XAResourceTransaction findPreviousBranchToJoin(CompositeTransaction ct) {
        List<XAResourceTransaction> candidates = this.findSiblingsForTransaction(ct);
        return this.findJoinableBranchInList(candidates);
    }

    private List<XAResourceTransaction> findSiblingsForTransaction(CompositeTransaction ct) {
        List<XAResourceTransaction> ret = this.siblingsOfSameRoot.get(ct);
        if (ret == null) {
            ret = new ArrayList<XAResourceTransaction>();
        }
        return Collections.unmodifiableList(ret);
    }

    private void rememberBranch(CompositeTransaction ct, XAResourceTransaction branch) {
        List<XAResourceTransaction> list = this.siblingsOfSameRoot.get(ct);
        if (list == null) {
            list = new ArrayList<XAResourceTransaction>();
            this.siblingsOfSameRoot.put(ct, list);
        }
        list.add(branch);
    }
}

