/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    private static final long serialVersionUID = 4796496938014754464L;
    private String meAsString;
    private int formatId;
    private int branchUsed = 0;
    private int globalUsed = 0;
    private byte[] branchQualifier = new byte[64];
    private byte[] globalTransactionId = new byte[64];
    private static final int DEFAULT_FORMAString = 1096044365;

    private XID(String tid) {
        this.formatId = 1096044365;
        this.branchQualifier[0] = 0;
        this.branchUsed = 1;
        this.globalTransactionId = tid.toString().getBytes();
        this.globalUsed = tid.toString().getBytes().length;
    }

    public XID(String tid, String resourceURL) {
        this(tid);
        this.branchQualifier = resourceURL.getBytes();
        this.branchUsed = this.branchQualifier.length;
        if (this.branchQualifier.length > 64) {
            throw new RuntimeException("Max branch qualifier length exceeded.");
        }
        if (this.globalUsed > 64) {
            throw new RuntimeException("Max global tid length exceeded.");
        }
    }

    public XID(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.globalUsed = xid.getGlobalTransactionId().length;
        this.branchQualifier = xid.getBranchQualifier();
        this.branchUsed = xid.getBranchQualifier().length;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Xid xid = (Xid)obj;
        return Arrays.equals(xid.getGlobalTransactionId(), this.getGlobalTransactionId()) && Arrays.equals(xid.getBranchQualifier(), this.getBranchQualifier());
    }

    public String toString() {
        if (this.meAsString == null) {
            this.meAsString = new String(this.getGlobalTransactionId()) + new String(this.getBranchQualifier());
        }
        return this.meAsString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

