/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class UserTransactionManager
implements TransactionManager,
Serializable,
Referenceable,
UserTransaction {
    private static final long serialVersionUID = -655789038710288096L;
    private transient TransactionManagerImp tm;
    private UserTransactionServiceImp uts;
    private boolean forceShutdown;
    private boolean startupTransactionService = true;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSetup() throws SystemException {
        if (this.closed) {
            throw new SystemException("This UserTransactionManager instance was closed already. Call init() to reuse if desired.");
        }
        if (this.tm != null) return;
        Class<TransactionManagerImp> clazz = TransactionManagerImp.class;
        synchronized (TransactionManagerImp.class) {
            this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
            if (this.tm != null) return;
            if (!this.getStartupTransactionService()) throw new SystemException("Transaction service not running");
            this.startupTransactionService();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void startupTransactionService() {
        this.uts = new UserTransactionServiceImp();
        this.uts.init();
        this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
    }

    private void shutdownTransactionService() {
        if (this.uts != null) {
            this.uts.shutdown(this.forceShutdown);
            this.uts = null;
        }
    }

    public void setStartupTransactionService(boolean startup) {
        this.startupTransactionService = startup;
    }

    public boolean getStartupTransactionService() {
        return this.startupTransactionService;
    }

    public void init() throws SystemException {
        this.closed = false;
        this.checkSetup();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkSetup();
        this.tm.begin();
    }

    public boolean getForceShutdown() {
        return this.forceShutdown;
    }

    public void setForceShutdown(boolean value) {
        this.forceShutdown = value;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        this.checkSetup();
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        this.checkSetup();
        return this.tm.getTransaction();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.resume(tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkSetup();
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int secs) throws SystemException {
        this.checkSetup();
        this.tm.setTransactionTimeout(secs);
    }

    public Transaction suspend() throws SystemException {
        this.checkSetup();
        return this.tm.suspend();
    }

    @Override
    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public void close() {
        this.shutdownTransactionService();
        this.closed = true;
    }
}

