/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.SiblingMapper;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XID;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.StateRecoveryManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class XATransactionalResource
implements TransactionalResource {
    private static final Logger LOGGER = LoggerFactory.createLogger(XATransactionalResource.class);
    protected XAResource xares_;
    protected String servername_;
    protected Hashtable recoveryMap_;
    protected Hashtable siblingmappers_;
    protected XidFactory xidFact_;
    private boolean closed_;
    private boolean weakCompare_;
    private boolean compareAlwaysTrue_;
    private String branchIdentifier_;
    private static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final int MAX_LONG_LEN = MAX_LONG_STR.getBytes().length;

    public XATransactionalResource(String servername) {
        this.servername_ = servername;
        this.siblingmappers_ = new Hashtable();
        if (servername.getBytes().length > 64 - MAX_LONG_LEN) {
            throw new RuntimeException("Max length of resource name exceeded: should be less than " + (64 - MAX_LONG_LEN));
        }
        this.xidFact_ = new DefaultXidFactory();
        this.closed_ = false;
        this.weakCompare_ = false;
        this.compareAlwaysTrue_ = false;
        this.branchIdentifier_ = servername;
    }

    public XATransactionalResource(String servername, XidFactory factory) {
        this(servername);
        this.xidFact_ = factory;
    }

    protected abstract XAResource refreshXAConnection() throws ResourceException;

    public XidFactory getXidFactory() {
        return this.xidFact_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSiblingMap(String root) {
        Hashtable hashtable = this.siblingmappers_;
        synchronized (hashtable) {
            this.siblingmappers_.remove(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SiblingMapper getSiblingMap(String root) {
        Hashtable hashtable = this.siblingmappers_;
        synchronized (hashtable) {
            if (this.siblingmappers_.containsKey(root)) {
                return (SiblingMapper)this.siblingmappers_.get(root);
            }
            SiblingMapper map = new SiblingMapper(this, root);
            this.siblingmappers_.put(root, map);
            return map;
        }
    }

    protected boolean needsRefresh() {
        boolean ret;
        block3: {
            ret = true;
            try {
                if (this.xares_ != null) {
                    this.xares_.isSameRM(this.xares_);
                    ret = false;
                }
            }
            catch (XAException xa) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.logDebug(this.servername_ + ": XAResource needs refresh?", (Throwable)xa);
            }
        }
        return ret;
    }

    public void useWeakCompare(boolean weakCompare) {
        this.weakCompare_ = weakCompare;
    }

    public boolean usesWeakCompare() {
        return this.weakCompare_;
    }

    public void setAcceptAllXAResources(boolean val) {
        this.compareAlwaysTrue_ = val;
    }

    public boolean acceptsAllXAResources() {
        return this.compareAlwaysTrue_;
    }

    public boolean usesXAResource(XAResource xares) {
        if (this.acceptsAllXAResources()) {
            return true;
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            return false;
        }
        boolean ret = false;
        if (!xares.getClass().getName().equals(xaresource.getClass().getName())) {
            ret = false;
        } else {
            try {
                if (xares.isSameRM(xaresource)) {
                    ret = true;
                } else if (this.usesWeakCompare()) {
                    ret = true;
                } else {
                    LOGGER.logDebug("XAResources claim to be different: " + xares + " and " + xaresource);
                }
            }
            catch (XAException xe) {
                Stack<XAException> errors = new Stack<XAException>();
                errors.push(xe);
                throw new SysException("Error in XAResource comparison: " + xe.getMessage(), errors);
            }
        }
        return ret;
    }

    public synchronized XAResource getXAResource() {
        if (this.needsRefresh()) {
            LOGGER.logDebug(this.servername_ + ": refreshing XAResource...");
            this.xares_ = this.refreshXAConnection();
            LOGGER.logInfo(this.servername_ + ": refreshed XAResource");
        }
        return this.xares_;
    }

    public ResourceTransaction getResourceTransaction(CompositeTransaction ct) throws ResourceException, IllegalStateException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (ct == null) {
            return null;
        }
        Stack lineage = ct.getLineage();
        String root = null;
        if (lineage == null || lineage.isEmpty()) {
            root = ct.getTid();
        } else {
            Stack tmp = (Stack)lineage.clone();
            while (!tmp.isEmpty()) {
                CompositeTransaction next = (CompositeTransaction)tmp.pop();
                if (!next.isRoot()) continue;
                root = next.getTid();
            }
        }
        return this.getSiblingMap(root).map(ct);
    }

    private StateRecoveryManager getRecoveryManager() throws ResourceException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        return null;
    }

    public String getName() {
        return this.servername_;
    }

    public void close() throws ResourceException {
        this.closed_ = true;
    }

    public boolean isClosed() throws ResourceException {
        return this.closed_;
    }

    public boolean isSameRM(RecoverableResource res) throws ResourceException {
        if (res == null || !(res instanceof XATransactionalResource)) {
            return false;
        }
        XATransactionalResource xatxres = (XATransactionalResource)res;
        if (xatxres.servername_ == null || this.servername_ == null) {
            return false;
        }
        return xatxres.servername_.equals(this.servername_);
    }

    public void setRecoveryService(RecoveryService recoveryService) throws ResourceException {
        if (recoveryService != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Installing recovery service on resource " + this.getName());
            }
            this.branchIdentifier_ = recoveryService.getName();
            recoveryService.recover();
        }
    }

    public synchronized boolean recover(Participant participant) throws ResourceException {
        boolean recovered = true;
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (!(participant instanceof XAResourceTransaction)) {
            throw new ResourceException("Wrong argument class: " + participant.getClass().getName());
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            LOGGER.logWarning("XATransactionalResource " + this.getName() + ": XAResource is NULL!");
            return false;
        }
        XAResourceTransaction xarestx = (XAResourceTransaction)participant;
        if (this.recoveryMap_ == null) {
            this.recover();
        }
        if (!this.recoveryMap_.containsKey(xarestx.getXid())) {
            recovered = false;
        }
        if (recovered || this.getName().equals(xarestx.getResourceName())) {
            xarestx.setRecoveredXAResource(this.getXAResource());
        }
        this.recoveryMap_.remove(xarestx.getXid());
        return recovered;
    }

    protected void recover() throws ResourceException {
        this.recoveryMap_ = new Hashtable();
        Xid[] recoveredlist = null;
        int flags = 0x1000000;
        boolean done = false;
        Stack<XAException> errors = new Stack<XAException>();
        Vector<XID> recoveredXids = new Vector<XID>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("recovery initiated for resource " + this.getName() + " with branchIdentifier " + this.branchIdentifier_);
        }
        do {
            try {
                recoveredlist = this.getXAResource().recover(flags);
            }
            catch (NullPointerException ora) {
                if (this.getXAResource().getClass().getName().toLowerCase().indexOf("oracle") >= 0) {
                    LOGGER.logWarning("ORACLE NOT CONFIGURED FOR XA? PLEASE CONTACT YOUR DBA TO FIX THIS...");
                }
                throw ora;
            }
            catch (XAException xaerr) {
                LOGGER.logWarning("Error in recovery", (Throwable)xaerr);
                errors.push(xaerr);
                throw new ResourceException("Error in recovery", errors);
            }
            flags = 0;
            boolean bl = done = recoveredlist == null || recoveredlist.length == 0;
            if (done) continue;
            done = true;
            for (int i = 0; i < recoveredlist.length; ++i) {
                XID xid = new XID(recoveredlist[i]);
                if (recoveredXids.contains(xid)) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo("Resource " + this.servername_ + " inspecting XID: " + xid);
                }
                recoveredXids.addElement(xid);
                done = false;
                String branch = new String(recoveredlist[i].getBranchQualifier());
                if (branch.startsWith(this.branchIdentifier_)) {
                    this.recoveryMap_.put(xid, new Object());
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.logInfo("Resource " + this.servername_ + " recovering XID: " + xid);
                    continue;
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.logInfo("Resource " + this.servername_ + ": XID " + xid + " with branch " + branch + " is not under my responsibility");
            }
        } while (!done);
        recoveredXids = null;
    }

    public void endRecovery() throws ResourceException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            return;
        }
        if (this.recoveryMap_ == null) {
            this.recover();
        }
        Enumeration toAbortList = this.recoveryMap_.keys();
        while (toAbortList.hasMoreElements()) {
            XID xid = (XID)toAbortList.nextElement();
            try {
                xaresource.rollback(xid);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.logInfo("XAResource.rollback ( " + xid + " ) called " + "on resource " + this.servername_);
            }
            catch (XAException xaerr) {}
        }
        this.recoveryMap_ = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("endRecovery() done for resource " + this.getName());
        }
    }

    public void setXidFactory(XidFactory factory) {
        this.xidFact_ = factory;
    }

    protected Xid createXid(String tid) {
        return this.getXidFactory().createXid(tid, this.branchIdentifier_);
    }
}

