/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class TemporaryXATransactionalResource
extends XATransactionalResource {
    private static final Logger LOGGER = LoggerFactory.createLogger(TemporaryXATransactionalResource.class);
    private static final int MAX_BYTES = 45;

    private static final String truncateNameTo45Bytes(String name) {
        String ret = name;
        if (ret.getBytes().length > 45) {
            ret = name.substring(0, 45);
        }
        if (ret.getBytes().length > 45) {
            ret = name.substring(0, 22);
        }
        return ret;
    }

    public TemporaryXATransactionalResource(XAResource xares) {
        super(TemporaryXATransactionalResource.truncateNameTo45Bytes(xares.toString()));
        this.xares_ = xares;
        this.getXAResource();
        try {
            if (!xares.isSameRM(xares)) {
                LOGGER.logWarning("XAResource " + xares + " of class " + xares.getClass().getName() + " does not correctly implement isSameRM(): " + "use explicit resource registration to save memory.");
            }
        }
        catch (XAException xAException) {
            // empty catch block
        }
    }

    protected XAResource refreshXAConnection() throws ResourceException {
        return this.xares_;
    }

    public boolean isClosed() {
        return this.needsRefresh();
    }
}

