/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jca;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import java.util.Stack;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.xa.XAResource;

public class JcaTransactionalResource
extends XATransactionalResource {
    private ManagedConnectionFactory mcf;
    private ManagedConnection connection;

    public JcaTransactionalResource(String servername, ManagedConnectionFactory mcf) {
        super(servername);
        this.mcf = mcf;
    }

    public JcaTransactionalResource(String servername, ManagedConnectionFactory mcf, XidFactory xidFactory) {
        super(servername, xidFactory);
        this.mcf = mcf;
    }

    public boolean usesXAResource(XAResource xares) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource refreshXAConnection() throws ResourceException {
        this.printMsg("refreshXAConnection() for resource: " + this.getName(), 2);
        XAResource ret = null;
        if (this.connection != null) {
            try {
                this.connection.destroy();
            }
            catch (Exception normal) {
                // empty catch block
            }
        }
        try {
            this.printMsg("about to block for new connection...", 2);
            this.connection = this.mcf.createManagedConnection(null, null);
        }
        catch (javax.resource.ResourceException e) {
            this.connection = null;
        }
        finally {
            this.printMsg("blocking done.", 2);
        }
        try {
            if (this.connection != null) {
                ret = this.connection.getXAResource();
            }
        }
        catch (javax.resource.ResourceException e) {
            this.printMsg("error getting XAResource: " + e.getMessage(), 1);
            Stack<javax.resource.ResourceException> errors = new Stack<javax.resource.ResourceException>();
            errors.push(e);
            throw new ResourceException("Error in getting XA resource", errors);
        }
        this.printMsg("refreshXAConnection() done.", 2);
        return ret;
    }

    public void close() throws ResourceException {
        super.close();
        try {
            if (this.connection != null) {
                this.connection.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

