/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.HeuristicMessageConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.transaction.xa.XAResource;

class DefaultJtaMessageConsumer
implements HeuristicMessageConsumer {
    private MessageConsumer receiver_;
    private TransactionalResource res_;
    private XAResourceTransaction restx_;
    private XAResource xares_;

    DefaultJtaMessageConsumer(MessageConsumer messageConsumer, TransactionalResource transactionalResource, XAResource xAResource) {
        this.receiver_ = messageConsumer;
        this.res_ = transactionalResource;
        this.xares_ = xAResource;
    }

    protected MessageConsumer getMessageConsumer() {
        return this.receiver_;
    }

    private synchronized void enlist() throws JMSException {
        if (this.restx_ != null) {
            throw new JMSException("JtaMessageConsumer.enlist: already enlisted");
        }
        CompositeTransactionManager compositeTransactionManager = Configuration.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            throw new JMSException("JtaMessageConsumer: requires Atomikos TransactionsEssentials to be running! Please make sure to start a transaction first.");
        }
        CompositeTransaction compositeTransaction = compositeTransactionManager.getCompositeTransaction();
        if (compositeTransaction == null || compositeTransaction.getProperty("com.atomikos.icatch.jta.transaction") == null) {
            throw new JMSException("JTA transaction required for JtaMessageConsumer");
        }
        this.restx_ = (XAResourceTransaction)this.res_.getResourceTransaction(compositeTransaction);
        this.restx_.setXAResource(this.xares_);
        this.restx_.resume();
    }

    private synchronized void delist(HeuristicMessage heuristicMessage) throws JMSException {
        if (this.restx_ == null) {
            throw new JMSException("JtaMessageConsumer.delist: not enlisted");
        }
        if (heuristicMessage != null) {
            this.restx_.addHeuristicMessage(heuristicMessage);
        }
        this.restx_.suspend();
        this.restx_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(HeuristicMessage heuristicMessage) throws JMSException {
        Message message = null;
        this.enlist();
        try {
            message = this.receiver_.receive();
            if (heuristicMessage == null && message != null) {
                heuristicMessage = new StringHeuristicMessage("Receipt of JMS Message with JMS ID : " + message.getJMSMessageID());
            }
        }
        finally {
            this.delist(heuristicMessage);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(HeuristicMessage heuristicMessage, long l) throws JMSException {
        Message message = null;
        this.enlist();
        try {
            message = this.receiver_.receive(l);
        }
        finally {
            this.delist(heuristicMessage);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait(HeuristicMessage heuristicMessage) throws JMSException {
        Message message = null;
        this.enlist();
        try {
            message = this.receiver_.receiveNoWait();
        }
        finally {
            this.delist(heuristicMessage);
        }
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        HeuristicMessage heuristicMessage = null;
        return this.receiveNoWait(heuristicMessage);
    }

    public Message receive(long l) throws JMSException {
        HeuristicMessage heuristicMessage = null;
        return this.receive(heuristicMessage, l);
    }

    public String getMessageSelector() throws JMSException {
        return this.receiver_.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.receiver_.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.receiver_.setMessageListener(messageListener);
    }

    public void close() throws JMSException {
        this.receiver_.close();
    }

    public Message receive(String string) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        return this.receive((HeuristicMessage)stringHeuristicMessage);
    }

    public Message receive(String string, long l) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        return this.receive((HeuristicMessage)stringHeuristicMessage, l);
    }

    public Message receiveNoWait(String string) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        return this.receiveNoWait((HeuristicMessage)stringHeuristicMessage);
    }

    public Message receive() throws JMSException {
        HeuristicMessage heuristicMessage = null;
        return this.receive(heuristicMessage);
    }
}

