/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.nonxa.ThreadLocalConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;

class NonXAParticipant
implements Participant,
Serializable {
    private boolean recovered = false;
    private ArrayList heuristicMessages = new ArrayList();
    private transient ThreadLocalConnection connection;

    public NonXAParticipant(ThreadLocalConnection threadLocalConnection) {
        this.connection = threadLocalConnection;
        this.heuristicMessages.add(new StringHeuristicMessage("JDBC driver does not support XA!"));
    }

    public boolean recover() throws SysException {
        this.recovered = true;
        return true;
    }

    public void setCascadeList(Dictionary dictionary) throws SysException {
    }

    public void setGlobalSiblingCount(int n) {
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        return 1;
    }

    public HeuristicMessage[] commit(boolean bl) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        if (this.recovered) {
            throw new HeurRollbackException(this.getHeuristicMessages());
        }
        try {
            this.connection.transactionTerminated(true);
        }
        catch (Exception exception) {
            Configuration.logWarning((String)"Error in non-XA commit", (Exception)exception);
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        return this.getHeuristicMessages();
    }

    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        if (!this.recovered) {
            try {
                this.connection.transactionTerminated(false);
            }
            catch (Exception exception) {
                Configuration.logWarning((String)"Error in non-XA rollback", (Exception)exception);
                throw new HeurHazardException(this.getHeuristicMessages());
            }
        }
        return this.getHeuristicMessages();
    }

    public void forget() {
    }

    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] heuristicMessageArray = new HeuristicMessage[]{};
        heuristicMessageArray = this.heuristicMessages.toArray(heuristicMessageArray);
        return heuristicMessageArray;
    }

    public String getURI() {
        return null;
    }

    void addHeuristicMessage(HeuristicMessage heuristicMessage) {
        this.heuristicMessages.add(heuristicMessage);
    }
}

