/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.BeanInspector;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.DataSourceShutdownHook;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.JtaDataSourceImp;
import com.atomikos.jdbc.XAConnectionFactory;
import com.atomikos.util.SerializableObjectFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SimpleDataSourceBean
implements HeuristicDataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable {
    private transient JtaDataSourceImp ds_ = null;
    private transient XADataSource xads_ = null;
    private String resourceName_ = "someUniqueName";
    private String xidFactory_ = "Default";
    private int poolSize_ = 1;
    private int connectionTimeout_ = 30;
    private boolean exclusive_ = true;
    private String validatingQuery_ = "";
    private String xaProperties_ = "";
    private String xaDataSourceClassName_ = "";
    private boolean testOnBorrow_ = false;

    private Properties parseProperties() {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(this.xaProperties_, ";");
        if (this.xaProperties_.indexOf(",") >= 0) {
            Configuration.logWarning((String)("xaDataSourceProperties: found comma(s) - please make sure to use ';' to separate properties: " + this.xaProperties_));
        } else if (stringTokenizer.countTokens() <= 1) {
            Configuration.logWarning((String)("xaDataSourceProperties: only one property found - please check format: " + this.xaProperties_));
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("=");
            if (n < 0) {
                throw new RuntimeException("Invalid xaDataSourceProperties format");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            properties.setProperty(string2, string3);
        }
        return properties;
    }

    private synchronized void checkSetup(boolean bl) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        this.ds_ = JtaDataSourceImp.getInstance(this.getUniqueResourceName());
        if (this.ds_ != null && !bl) {
            return;
        }
        if (this.xads_ == null && (this.getXaDataSourceClassName() == null || this.getXaDataSourceClassName().length() == 0)) {
            throw new SQLException("SimpleDataSourceBean: xaDataSourceClassName not set.");
        }
        if (this.xidFactory_ == null) {
            throw new SQLException("SimpleDataSourceBean: xidFormat not set.");
        }
        if (this.xads_ == null) {
            try {
                serializable = Class.forName(this.getXaDataSourceClassName());
                this.xads_ = (XADataSource)serializable.newInstance();
                object3 = new BeanInspector((Object)this.xads_);
                object2 = this.parseProperties();
                object = ((Properties)object2).propertyNames();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    String string2 = ((Properties)object2).getProperty(string);
                    object3.setPropertyValue(string, string2);
                }
            }
            catch (Exception exception) {
                Configuration.logWarning((String)("SimpleDataSourceBean: could not configure XADataSource of class " + this.getXaDataSourceClassName()), (Exception)exception);
                throw new SQLException("Could not configure XADataSource: " + exception.getMessage() + " " + exception.getClass().getName());
            }
        }
        serializable = null;
        serializable = this.getXaDataSourceClassName().toLowerCase().indexOf("oracle") < 0 ? new DefaultXidFactory() : new OraXidFactory();
        object3 = new XAConnectionFactory(this.resourceName_, "", "", this.xads_, (XidFactory)((Object)serializable));
        ((XAConnectionFactory)object3).setExclusive(this.exclusive_);
        this.ds_ = new JtaDataSourceImp((XAConnectionFactory)object3, this.poolSize_, this.connectionTimeout_, bl, !bl, this.validatingQuery_, this.testOnBorrow_);
        object2 = new DataSourceShutdownHook(this.ds_);
        Runtime.getRuntime().addShutdownHook((Thread)object2);
        object = new StringBuffer();
        ((StringBuffer)object).append("SimpleDataSourceBean configured with [");
        ((StringBuffer)object).append("resourceName=").append(this.resourceName_).append(", ");
        ((StringBuffer)object).append("xidFactory=").append(this.xidFactory_).append(", ");
        ((StringBuffer)object).append("poolSize=").append(this.poolSize_).append(", ");
        ((StringBuffer)object).append("connectionTimeout=").append(this.connectionTimeout_).append(", ");
        ((StringBuffer)object).append("exclusive=").append(this.exclusive_).append(", ");
        ((StringBuffer)object).append("validatingQuery=").append(this.validatingQuery_).append(", ");
        ((StringBuffer)object).append("xaProperties=").append(this.xaProperties_).append(", ");
        ((StringBuffer)object).append("xaDataSourceClassName=").append(this.xaDataSourceClassName_).append(", ");
        ((StringBuffer)object).append("testOnBorrow=").append(this.testOnBorrow_);
        ((StringBuffer)object).append("]");
        Configuration.logDebug((String)((StringBuffer)object).toString());
    }

    private synchronized void checkSetup() throws SQLException {
        this.checkSetup(false);
    }

    public void init() throws SQLException {
        this.checkSetup(false);
    }

    public void setUniqueResourceName(String string) {
        this.resourceName_ = string;
    }

    public String getUniqueResourceName() {
        return this.resourceName_;
    }

    public void setConnectionPoolSize(int n) {
        this.poolSize_ = n;
    }

    public int getConnectionPoolSize() {
        return this.poolSize_;
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow_ = bl;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow_;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout_ = n;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout_;
    }

    public void setExclusiveConnectionMode(boolean bl) {
        this.exclusive_ = bl;
    }

    public boolean getExclusiveConnectionMode() {
        return this.exclusive_;
    }

    protected TransactionalResource getTransactionalResource() {
        try {
            this.checkSetup();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException.getMessage());
        }
        return this.ds_.getTransactionalResource();
    }

    public void setValidatingQuery(String string) {
        this.validatingQuery_ = string;
    }

    public String getValidatingQuery() {
        return this.validatingQuery_;
    }

    public void setXaDataSourceClassName(String string) {
        this.xaDataSourceClassName_ = string;
    }

    public String getXaDataSourceClassName() {
        String string = this.xaDataSourceClassName_;
        if (string == null && this.xads_ != null) {
            string = this.xads_.getClass().getName();
        }
        return string;
    }

    public void setXaDataSourceProperties(String string) {
        this.xaProperties_ = string;
    }

    public String getXaDataSourceProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.xaProperties_ != null) {
            stringBuffer.append(this.xaProperties_);
        }
        if (stringBuffer.length() == 0 && this.xads_ != null) {
            try {
                BeanInspector beanInspector = new BeanInspector((Object)this.xads_);
                Property[] propertyArray = beanInspector.getProperties();
                for (int i = 0; i < propertyArray.length; ++i) {
                    String string = propertyArray[i].getName();
                    String string2 = beanInspector.getPropertyValue(string);
                    stringBuffer.append(string);
                    stringBuffer.append("=");
                    stringBuffer.append(string2);
                    if (i >= propertyArray.length - 1) continue;
                    stringBuffer.append(";");
                }
            }
            catch (PropertyException propertyException) {
                Configuration.logWarning((String)"Error in getXaDataSourceProperties", (Exception)((Object)propertyException));
                throw new UndeclaredThrowableException(propertyException);
            }
        }
        return stringBuffer.toString();
    }

    public void setXaDataSource(XADataSource xADataSource) {
        this.xads_ = xADataSource;
    }

    public XADataSource getXaDataSource() {
        return this.xads_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String string = this.getValidatingQuery();
        if (string == null || string.equals("")) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.ds_.getConnection();
            try {
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                statement.close();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Configuration.logWarning((String)("Error in validating query for resource " + this.getUniqueResourceName()), (Exception)sQLException);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2);
    }

    public Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(heuristicMessage);
    }

    public Connection getConnection(String string, String string2, HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2, heuristicMessage);
    }

    public Connection getConnection(String string) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string);
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2, string3);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup();
        return this.ds_.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup();
        return this.ds_.getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.checkSetup();
        this.ds_.setLoginTimeout(n);
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.checkSetup();
        this.ds_.setLogWriter(printWriter);
    }

    public void close() throws SQLException {
        if (this.ds_ != null) {
            this.ds_.close();
        }
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        this.checkSetup();
        ExternalXAPooledConnectionImp externalXAPooledConnectionImp = null;
        XAConnection xAConnection = this.xads_.getXAConnection();
        externalXAPooledConnectionImp = new ExternalXAPooledConnectionImp(xAConnection, this.getTransactionalResource(), this.getLogWriter());
        return externalXAPooledConnectionImp;
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        ExternalXAPooledConnectionImp externalXAPooledConnectionImp = null;
        this.checkSetup();
        XAConnection xAConnection = this.xads_.getXAConnection(string, string2);
        externalXAPooledConnectionImp = new ExternalXAPooledConnectionImp(xAConnection, this.getTransactionalResource(), this.getLogWriter());
        return externalXAPooledConnectionImp;
    }
}

