/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jmx;

import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.jmx.JmxTransactionalResourceMBean;
import com.atomikos.datasource.xa.jmx.XAResourceConfig;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxTransactionalResource
implements JmxTransactionalResourceMBean,
MBeanRegistration {
    private XATransactionalResource resource;
    private XAResourceConfig config;
    private String localName;

    public JmxTransactionalResource(XATransactionalResource xATransactionalResource, XAResourceConfig xAResourceConfig, String string) {
        this.resource = xATransactionalResource;
        this.config = xAResourceConfig;
        this.localName = string;
        this.setUseWeakCompare(xAResourceConfig.usesWeakCompare());
        this.setUseOracleXIDFormat(xAResourceConfig.usesOracleXidFormat());
        this.setAcceptAllXAResources(xAResourceConfig.acceptsAllXAResources());
    }

    public boolean getUseWeakCompare() {
        return this.resource.usesWeakCompare();
    }

    public void setUseWeakCompare(boolean bl) {
        this.resource.useWeakCompare(bl);
        this.config.setUseWeakCompare(bl);
    }

    public boolean getUseOracleXIDFormat() {
        boolean bl = false;
        bl = !this.resource.getXidFactory().getClass().getName().endsWith("DefaultXidFactory");
        return bl;
    }

    public void setUseOracleXIDFormat(boolean bl) {
        if (bl) {
            this.resource.setXidFactory(new OraXidFactory());
        } else {
            this.resource.setXidFactory(new DefaultXidFactory());
        }
        this.config.setUseOracleXidFormat(bl);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName("atomikos.resources", "name", this.resource.getName());
        }
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public boolean getAcceptAllXAResources() {
        return this.resource.acceptsAllXAResources();
    }

    public void setAcceptAllXAResources(boolean bl) {
        this.resource.setAcceptAllXAResources(bl);
        this.config.setAcceptAllXAResources(bl);
    }
}

