/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractJmsSessionProxy;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

class AtomikosJmsNonXaSessionProxy
extends AbstractJmsSessionProxy {
    private static final String CLOSE_METHOD = "close";
    private Session delegate;
    private boolean closed = false;
    private boolean errorsOccurred = false;
    private SessionHandleStateChangeListener owner;
    private SessionHandleStateChangeListener connectionProxy;

    public static Object newInstance(Session s, SessionHandleStateChangeListener pooledConnection, SessionHandleStateChangeListener connectionProxy) throws JMSException {
        AtomikosJmsNonXaSessionProxy proxy = new AtomikosJmsNonXaSessionProxy(s, pooledConnection, connectionProxy);
        Set interfaces = PropertyUtils.getAllImplementedInterfaces(s.getClass());
        interfaces.add(DynamicProxy.class);
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(s.getClass().getClassLoader());
        classLoaders.add(AtomikosJmsNonXaSessionProxy.class.getClassLoader());
        return (Session)ClassLoadingHelper.newProxyInstance(classLoaders, (Class[])interfaceClasses, (InvocationHandler)proxy);
    }

    private AtomikosJmsNonXaSessionProxy(Session s, SessionHandleStateChangeListener pooledConnection, SessionHandleStateChangeListener connectionProxy) {
        this.delegate = s;
        this.owner = pooledConnection;
        this.connectionProxy = connectionProxy;
    }

    private void checkForTransactionContextAndLogWarningIfSo() {
        TransactionManager tm = TransactionManagerImp.getTransactionManager();
        if (tm != null) {
            Transaction tx = null;
            try {
                tx = tm.getTransaction();
            }
            catch (SystemException e) {
                Configuration.logDebug((String)(this + ": Failed to get transaction."), (Throwable)e);
            }
            if (tx != null) {
                String msg = this + ": WARNING - detected JTA transaction context while using non-transactional session." + "\n" + "Beware that any JMS operations you perform are NOT part of the JTA transaction." + "\n" + "To enable JTA, make sure to do all of the following:" + "\n" + "1. Make sure that the AtomikosConnectionFactoryBean is configured with localTransactionMode=false, and" + "\n" + "2. Make sure to call create JMS sessions with the transacted flag set to true.";
                Configuration.logInfo((String)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws JMSException {
        String methodName = method.getName();
        if (methodName.equals("getInvocationHandler")) {
            return this;
        }
        AtomikosJmsNonXaSessionProxy atomikosJmsNonXaSessionProxy = this;
        synchronized (atomikosJmsNonXaSessionProxy) {
            if (this.closed) {
                if (!methodName.equals(CLOSE_METHOD)) {
                    String msg = "Session was closed already - calling " + methodName + " is no longer allowed.";
                    Configuration.logWarning((String)(this + ": " + msg));
                    throw new IllegalStateException(msg);
                }
                return null;
            }
            if (CLOSE_METHOD.equals(methodName)) {
                Configuration.logInfo((String)(this + ": close..."));
                this.destroy();
                return null;
            }
            this.checkForTransactionContextAndLogWarningIfSo();
            try {
                Configuration.logInfo((String)(this + ": calling " + methodName + " on vendor session..."));
                Object ret = method.invoke((Object)this.delegate, args);
                Configuration.logDebug((String)(this + ": " + methodName + " returning " + ret));
                return ret;
            }
            catch (Exception ex) {
                this.errorsOccurred = true;
                String msg = "Error delegating " + methodName + " call to JMS driver";
                this.convertProxyError(ex, msg);
            }
        }
        return null;
    }

    protected void destroy() {
        try {
            Configuration.logInfo((String)(this + ": destroying session..."));
            if (!this.closed) {
                this.closed = true;
                this.delegate.close();
                this.owner.onTerminated();
                this.connectionProxy.onTerminated();
            }
        }
        catch (JMSException e) {
            Configuration.logWarning((String)(this + ": could not close JMS session"), (Throwable)e);
        }
    }

    protected boolean isAvailable() {
        return this.closed;
    }

    protected boolean isErroneous() {
        return this.errorsOccurred;
    }

    protected boolean isInTransaction(CompositeTransaction ct) {
        return false;
    }

    public String toString() {
        return "atomikos non-xa session proxy for vendor instance " + this.delegate;
    }
}

