/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.jms.HeuristicMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

class AtomikosJmsMessageProducerProxy
extends ConsumerProducerSupport
implements HeuristicMessageProducer {
    private MessageProducer delegate;

    AtomikosJmsMessageProducerProxy(MessageProducer delegate, SessionHandleState state) {
        super(state);
        this.delegate = delegate;
    }

    public void send(Message msg, String heuristicMessage) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( message , heuristicMessage )..."));
        this.enlist(heuristicMessage);
        this.delegate.send(msg);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void send(Destination dest, Message msg, String heuristicMessage) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( destination , message , heuristicMessage )..."));
        this.enlist(heuristicMessage);
        this.delegate.send(dest, msg);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive, String heuristicMessage) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( message , deliveryMode , priority , timeToLive , heuristicMessage )..."));
        this.enlist(heuristicMessage);
        this.delegate.send(msg, deliveryMode, priority, timeToLive);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive, String heuristicMessage) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( destination , message , deliveryMode , priority , timeToLive , heuristicMessage )..."));
        this.enlist(heuristicMessage);
        this.delegate.send(dest, msg, deliveryMode, priority, timeToLive);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void close() throws JMSException {
        Configuration.logInfo((String)(this + ": close..."));
        this.delegate.close();
        Configuration.logDebug((String)(this + ": close done."));
    }

    public int getDeliveryMode() throws JMSException {
        Configuration.logInfo((String)(this + ": getDeliveryMode()..."));
        int ret = this.delegate.getDeliveryMode();
        Configuration.logDebug((String)(this + ": getDeliveryMode() returning " + ret));
        return ret;
    }

    public Destination getDestination() throws JMSException {
        Configuration.logInfo((String)(this + ": getDestination()..."));
        Destination ret = this.delegate.getDestination();
        Configuration.logDebug((String)(this + ": getDestination() returning " + ret));
        return ret;
    }

    public boolean getDisableMessageID() throws JMSException {
        Configuration.logInfo((String)(this + ": getDisableMessageID()..."));
        boolean ret = this.delegate.getDisableMessageID();
        Configuration.logDebug((String)(this + ": getDisableMessageID() returning " + ret));
        return ret;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        Configuration.logInfo((String)(this + ": getDisableMessageTimestamp()..."));
        boolean ret = this.delegate.getDisableMessageTimestamp();
        Configuration.logDebug((String)(this + ": getDisableMessageTimestamp() returning " + ret));
        return ret;
    }

    public int getPriority() throws JMSException {
        Configuration.logInfo((String)(this + ": getPriority()..."));
        int ret = this.delegate.getPriority();
        Configuration.logDebug((String)(this + ": getPriority() returning " + ret));
        return ret;
    }

    public long getTimeToLive() throws JMSException {
        Configuration.logInfo((String)(this + ": getTimeToLive()..."));
        long ret = this.delegate.getTimeToLive();
        Configuration.logDebug((String)(this + ": getTimeToLive() returning " + ret));
        return ret;
    }

    public void send(Message msg) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( message )..."));
        this.send(msg, null);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void send(Destination dest, Message msg) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( destination , message )..."));
        this.send(dest, msg, null);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void send(Message msg, int deliveryMode, int pty, long ttl) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( message , deliveryMode , priority , timeToLive )..."));
        this.send(msg, deliveryMode, pty, ttl, null);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void send(Destination dest, Message msg, int mode, int pty, long ttl) throws JMSException {
        Configuration.logInfo((String)(this + ": send ( destination , message , deliveryMode , priority , timeToLive )..."));
        this.send(dest, msg, mode, pty, ttl, null);
        Configuration.logDebug((String)(this + ": send done."));
    }

    public void setDeliveryMode(int mode) throws JMSException {
        Configuration.logInfo((String)(this + ": setDeliveryMode ( " + mode + " )..."));
        this.delegate.setDeliveryMode(mode);
        Configuration.logDebug((String)(this + ": setDeliveryMode done."));
    }

    public void setDisableMessageID(boolean mode) throws JMSException {
        Configuration.logInfo((String)(this + ": setDisableMessageID ( " + mode + " )..."));
        this.delegate.setDisableMessageID(mode);
        Configuration.logDebug((String)(this + ": setDisableMessageID done."));
    }

    public void setDisableMessageTimestamp(boolean mode) throws JMSException {
        Configuration.logInfo((String)(this + ": setDisableMessageTimestamp ( " + mode + " )..."));
        this.delegate.setDisableMessageTimestamp(mode);
        Configuration.logDebug((String)(this + ": setDisableMessageTimestamp done."));
    }

    public void setPriority(int pty) throws JMSException {
        Configuration.logInfo((String)(this + ": setPriority ( " + pty + " )..."));
        this.delegate.setPriority(pty);
        Configuration.logDebug((String)(this + ": setPriority done."));
    }

    public void setTimeToLive(long ttl) throws JMSException {
        Configuration.logInfo((String)(this + ": setTimeToLive ( " + ttl + " )..."));
        this.delegate.setTimeToLive(ttl);
        Configuration.logDebug((String)(this + ": setTimeToLive done."));
    }

    public String toString() {
        return "atomikos MessageProducer proxy for " + this.delegate;
    }
}

