/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.jms.DefaultJtaConnection;
import com.atomikos.jms.JtaTopicSession;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;

class JtaTopicConnection
extends DefaultJtaConnection
implements TopicConnection {
    protected JtaTopicConnection(XATopicConnection c, TransactionalResource res) {
        super((XAConnection)c, res);
    }

    private XATopicConnection getTopicConnection() {
        return (XATopicConnection)this.getConnection();
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        TopicSession ret = null;
        if (!transacted && !JtaTopicConnection.inJtaTransaction()) {
            ret = this.getTopicConnection().createTopicSession(false, ackMode);
        } else {
            JtaTopicConnection.forceConnectionIntoXaMode(this.getConnection());
            XATopicSession xasession = this.getTopicConnection().createXATopicSession();
            ret = new JtaTopicSession(xasession, this.getTransactionalResource(), xasession.getXAResource());
        }
        return ret;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool pool, int value) throws JMSException {
        throw new JMSException("Not supported");
    }
}

