/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.jms.JndiObjectFactory;
import com.atomikos.jms.JtaQueueConnection;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class JtaQueueConnectionFactory
implements QueueConnectionFactory,
Referenceable {
    private static HashMap nameToFactory_ = new HashMap();
    private XAQueueConnectionFactory factory_;
    private JmsTransactionalResource res_;

    static Reference createReference(String uniqueName) {
        StringRefAddr ra = new StringRefAddr("ResourceName", uniqueName);
        Reference ref = new Reference(JtaQueueConnectionFactory.class.getName(), new StringRefAddr("name", "JtaQueueConnectionFactory"), JndiObjectFactory.class.getName(), null);
        ref.add(ra);
        return ref;
    }

    static JtaQueueConnectionFactory getInstance(String name) {
        JtaQueueConnectionFactory ret = (JtaQueueConnectionFactory)nameToFactory_.get(name);
        if (ret != null && ret.getTransactionalResource().isClosed()) {
            JtaQueueConnectionFactory.removeFromMap(name);
            ret = null;
        }
        return ret;
    }

    static synchronized JtaQueueConnectionFactory getOrCreate(String resourceName, XAQueueConnectionFactory qFactory, XidFactory xFactory) {
        JtaQueueConnectionFactory ret = JtaQueueConnectionFactory.getInstance(resourceName);
        if (ret == null) {
            ret = new JtaQueueConnectionFactory(resourceName, qFactory, xFactory);
            JtaQueueConnectionFactory.addToMap(resourceName, ret);
        }
        return ret;
    }

    private static synchronized void addToMap(String name, JtaQueueConnectionFactory instance) {
        nameToFactory_.put(name, instance);
    }

    private static synchronized void removeFromMap(String name) {
        nameToFactory_.remove(name);
    }

    public JtaQueueConnectionFactory(String resourceName, XAQueueConnectionFactory factory) {
        this.factory_ = factory;
        this.res_ = new JmsTransactionalResource(resourceName, (XAConnectionFactory)factory);
        JtaQueueConnectionFactory.addToMap(this.res_.getName(), this);
    }

    public JtaQueueConnectionFactory(String resourceName, XAQueueConnectionFactory qFactory, XidFactory xFactory) {
        this.factory_ = qFactory;
        this.res_ = new JmsTransactionalResource(resourceName, (XAConnectionFactory)qFactory, xFactory);
        JtaQueueConnectionFactory.addToMap(this.res_.getName(), this);
    }

    public JmsTransactionalResource getTransactionalResource() {
        return this.res_;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        XAQueueConnection xac = this.factory_.createXAQueueConnection();
        return new JtaQueueConnection(xac, (TransactionalResource)this.res_);
    }

    public QueueConnection createQueueConnection(String user, String pw) throws JMSException {
        XAQueueConnection xac = this.factory_.createXAQueueConnection(user, pw);
        return new JtaQueueConnection(xac, (TransactionalResource)this.res_);
    }

    public Reference getReference() throws NamingException {
        return JtaQueueConnectionFactory.createReference(this.res_.getName());
    }

    public Connection createConnection() throws JMSException {
        return this.createQueueConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createQueueConnection(userName, password);
    }
}

