/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.MessageProducerSession;
import com.atomikos.jms.MessageProducerSessionFactory;
import java.util.Enumeration;
import java.util.Stack;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public abstract class AbstractBridge
implements MessageListener {
    private MessageProducerSessionFactory destinationFactory;
    private ThreadLocal destinationMap = new ThreadLocal();

    protected AbstractBridge() {
    }

    private MessageProducerSession getDestination() {
        MessageProducerSession ret = null;
        ret = (MessageProducerSession)this.destinationMap.get();
        if (ret == null) {
            ret = this.destinationFactory.createMessageProducerSession();
            this.destinationMap.set(ret);
        }
        return ret;
    }

    public void setDestinationSessionFactory(MessageProducerSessionFactory destinationFactory) {
        this.destinationFactory = destinationFactory;
    }

    protected TextMessage createTextMessage() throws JMSException {
        TextMessage ret = null;
        ret = this.getDestination().createTextMessage();
        return ret;
    }

    protected BytesMessage createBytesMessage() throws JMSException {
        BytesMessage ret = null;
        ret = this.getDestination().createBytesMessage();
        return ret;
    }

    protected StreamMessage createStreamMessage() throws JMSException {
        StreamMessage ret = null;
        ret = this.getDestination().createStreamMessage();
        return ret;
    }

    protected ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage ret = null;
        ret = this.getDestination().createObjectMessage();
        return ret;
    }

    protected MapMessage createMapMessage() throws JMSException {
        MapMessage ret = null;
        ret = this.getDestination().createMapMessage();
        return ret;
    }

    protected void copyHeadersAndProperties(Message fromMessage, Message toMessage) throws JMSException {
        Enumeration names = fromMessage.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object val = fromMessage.getObjectProperty(name);
            toMessage.setObjectProperty(name, val);
        }
        String corrId = fromMessage.getJMSCorrelationID();
        toMessage.setJMSCorrelationID(corrId);
        this.getDestination().setPriority(fromMessage.getJMSPriority());
        long expiry = fromMessage.getJMSExpiration();
        if (expiry > 0L) {
            long now = System.currentTimeMillis();
            long ttl = expiry - now;
            if (ttl < 0L) {
                throw new JMSException("Message has expired");
            }
            this.getDestination().setTimeToLive(ttl);
        } else {
            this.getDestination().setTimeToLive(0L);
        }
        String type = fromMessage.getJMSType();
        toMessage.setJMSType(type);
        this.getDestination().setDeliveryMode(fromMessage.getJMSDeliveryMode());
    }

    protected abstract Message bridgeMessage(Message var1) throws JMSException;

    public final void onMessage(Message message) {
        try {
            if (message == null) {
                Configuration.logInfo((String)"Stopping JMS Bridge");
                this.getDestination().stop();
            } else {
                Message transformedMsg = this.bridgeMessage(message);
                if (transformedMsg != null) {
                    this.getDestination().sendMessage(transformedMsg);
                }
            }
        }
        catch (JMSException e) {
            Configuration.logInfo((String)"Bridge: error during message processing", (Throwable)e);
            Configuration.logInfo((String)("Bridge: linked exception is " + e.getLinkedException()));
            Stack<JMSException> errors = new Stack<JMSException>();
            errors.push(e);
            throw new SysException("Error during message processing", errors);
        }
    }
}

