//$Id: JndiObjectFactory.java,v 1.2 2006/10/30 10:37:09 guy Exp $
//$Log: JndiObjectFactory.java,v $
//Revision 1.2  2006/10/30 10:37:09  guy
//Merged in changes of 3.1.0 release
//
//Revision 1.1.1.1.4.1  2006/10/13 13:07:03  guy
//ADDED 1010
//
//Revision 1.1.1.1  2006/08/29 10:01:12  guy
//Import of 3.0 essentials edition.
//
//Revision 1.1.1.1  2006/04/29 08:55:38  guy
//Initial import.
//
//Revision 1.1.1.1  2006/03/29 13:21:31  guy
//Imported.
//
//Revision 1.1.1.1  2006/03/23 16:25:28  guy
//Imported.
//
//Revision 1.1.1.1  2006/03/22 13:46:54  guy
//Import.
//
//Revision 1.2  2006/03/15 10:32:05  guy
//Formatted code.
//
//Revision 1.1.1.1  2006/03/09 14:59:15  guy
//Imported 3.0 development into CVS repository.
//
//Revision 1.2  2005/08/09 15:25:21  guy
//Updated javadoc.
//
//Revision 1.1.1.1  2004/09/18 12:42:50  guy
//Added separate JMS module.
//
//Revision 1.2  2004/03/22 15:39:38  guy
//Merged-in changes from branch redesign-4-2003.
//
//Revision 1.1.2.1  2003/05/18 09:43:35  guy
//Added JNDI support and bean config support.
//


              
/*
 * Copyright 2000-2008, Atomikos (http://www.atomikos.com) 
 *
 * This code ("Atomikos TransactionsEssentials"), by itself, 
 * is being distributed under the 
 * Apache License, Version 2.0 ("License"), a copy of which may be found at 
 * http://www.atomikos.com/licenses/apache-license-2.0.txt . 
 * You may not use this file except in compliance with the License. 
 *             
 * While the License grants certain patent license rights, 
 * those patent license rights only extend to the use of 
 * Atomikos TransactionsEssentials by itself. 
 *             
 * This code (Atomikos TransactionsEssentials) contains certain interfaces 
 * in package (namespace) com.atomikos.icatch
 * (including com.atomikos.icatch.Participant) which, if implemented, may
 * infringe one or more patents held by Atomikos.  
 * It should be appreciated that you may NOT implement such interfaces; 
 * licensing to implement these interfaces must be obtained separately from Atomikos.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  
 */
 
package com.atomikos.jms;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/**
 * 
 * 
 * An object factory for JMS administrated objects.
 */

public class JndiObjectFactory implements ObjectFactory
{
    public JndiObjectFactory ()
    {
    }

    public Object getObjectInstance ( Object obj , Name name , Context nameCtx ,
            Hashtable environment ) throws Exception
    {
    		Object ret = null;
        if ( !(obj instanceof Reference) )
            return null;
        
        Reference ref = (Reference) obj;
        String className = ref.getClassName();
        if ( JtaQueueConnectionFactory.class.getName ().equals ( className ) ) {
        		String url = (String) ref.get ( "ResourceName" ).getContent ();
        		ret = JtaQueueConnectionFactory.getInstance ( url );
        }   
        else if ( JtaTopicConnectionFactory.class.getName ().equals ( className ) ) {
        		String url = (String) ref.get ( "ResourceName" ).getContent ();
        		ret = JtaTopicConnectionFactory.getInstance ( url );
        }
        else {
        		ret = null;
        		//as required by JNDI
        }
        
        return ret;
    }

}