/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.jdbc.AbstractConnectionProxy;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.JdbcConnectionProxyHelper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class AtomikosConnectionProxy
extends AbstractConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosConnectionProxy.class);
    private static final List<String> ENLISTMENT_METHODS = Arrays.asList("createStatement", "prepareStatement", "prepareCall");
    private static final List<String> CLOSE_METHODS = Arrays.asList("close");
    private static final List<String> XA_INCOMPATIBLE_METHODS = Arrays.asList("commit", "rollback", "setSavepoint", "releaseSavepoint");
    private static Class<?>[] MINIMUM_SET_OF_INTERFACES = new Class[]{Reapable.class, DynamicProxy.class, Connection.class};
    private final Connection delegate;
    private SessionHandleState sessionHandleState;
    private boolean closed = false;
    private boolean reaped = false;
    private String toString;

    private AtomikosConnectionProxy(Connection c, SessionHandleState sessionHandleState) {
        this.delegate = c;
        this.sessionHandleState = sessionHandleState;
        sessionHandleState.notifySessionBorrowed();
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer ret = new StringBuffer();
            ret.append("atomikos connection proxy for ");
            ret.append(this.delegate);
            this.toString = ret.toString();
        }
        return this.toString;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName.equals("getInvocationHandler")) {
            return this;
        }
        if (methodName.equals("reap")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": reaping pending connection...");
            }
            this.reap();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": reap done!");
            }
            return null;
        }
        if (methodName.equals("isClosed")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": isClosed()...");
            }
            Boolean ret = this.closed;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": isClosed() returning " + ret);
            }
            return ret;
        }
        if (this.closed && !this.methodAllowedAfterClose(method)) {
            if (this.reaped) {
                String msg = "Connection has been reaped - calling " + methodName + " is no longer allowed! Increase reapTimeout to avoid this problem.";
                AtomikosSQLException.throwAtomikosSQLException(msg);
            } else {
                String msg = "Connection was already closed - calling " + methodName + " is no longer allowed!";
                AtomikosSQLException.throwAtomikosSQLException(msg);
            }
            return null;
        }
        if (this.isEnlistedInGlobalTransaction()) {
            if (XA_INCOMPATIBLE_METHODS.contains(methodName)) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call method '" + methodName + "' while a global transaction is running");
            }
            if (methodName.equals("setAutoCommit") && args[0].equals(Boolean.TRUE)) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call 'setAutoCommit(true)' while a global transaction is running");
            }
            if (methodName.equals("getAutoCommit")) {
                return Boolean.FALSE;
            }
        }
        if (ENLISTMENT_METHODS.contains(methodName)) {
            try {
                this.enlist();
            }
            catch (Exception e) {
                this.sessionHandleState.notifySessionErrorOccurred();
                JdbcConnectionProxyHelper.convertProxyError(e, "Error enlisting in transaction - connection might be broken? Please check the logs for more information...");
            }
        }
        Object ret = null;
        if (CLOSE_METHODS.contains(methodName) && args == null) {
            this.close();
            return null;
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": calling " + this.formatCallDetails(method, args) + "...");
            }
            ret = method.invoke((Object)this.delegate, args);
        }
        catch (Exception ex) {
            this.sessionHandleState.notifySessionErrorOccurred();
            JdbcConnectionProxyHelper.convertProxyError(ex, "Error delegating '" + methodName + "' call");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": " + methodName + " returning " + ret);
        }
        if (ret instanceof Statement) {
            Statement s = (Statement)ret;
            this.addStatement(s);
        }
        return ret;
    }

    private boolean methodAllowedAfterClose(Method method) {
        return method.getName().equals("close") || ClassLoadingHelper.existsInJavaObjectClass((Method)method);
    }

    private String formatCallDetails(Method method, Object[] args) {
        StringBuffer ret = new StringBuffer();
        ret.append(method.getName());
        if (args != null && args.length > 0) {
            ret.append("(");
            for (int i = 0; i < args.length; ++i) {
                ret.append(args[i].toString());
                if (i >= args.length - 1) continue;
                ret.append(",");
            }
            ret.append(")");
        }
        return ret.toString();
    }

    private void reap() {
        LOGGER.logWarning(this + ": reaping - check if the application closes connections correctly, or increase the reapTimeout value");
        this.close();
        this.sessionHandleState.notifySessionErrorOccurred();
        this.reaped = true;
    }

    private CompositeTransactionManager getCompositeTransactionManager() {
        CompositeTransactionManager ret = Configuration.getCompositeTransactionManager();
        if (ret == null) {
            LOGGER.logWarning(this + ": WARNING: transaction manager not running?");
        }
        return ret;
    }

    private boolean enlist() throws AtomikosSQLException {
        boolean ret = false;
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": notifyBeforeUse " + this.sessionHandleState);
            }
            CompositeTransaction ct = null;
            CompositeTransactionManager ctm = this.getCompositeTransactionManager();
            if (ctm != null) {
                ct = ctm.getCompositeTransaction();
                this.sessionHandleState.notifyBeforeUse(ct);
                if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
                    ret = true;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace(this + ": detected transaction " + ct);
                    }
                    if (ct.getState().equals((Object)TxState.ACTIVE)) {
                        ct.registerSynchronization((Synchronization)new JdbcRequeueSynchronization(this, ct));
                    } else {
                        AtomikosSQLException.throwAtomikosSQLException("The transaction has timed out - try increasing the timeout if needed");
                    }
                }
            }
        }
        catch (InvalidSessionHandleStateException ex) {
            AtomikosSQLException.throwAtomikosSQLException(ex.getMessage(), ex);
        }
        return ret;
    }

    private void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": close()...");
        }
        this.forceCloseAllPendingStatements(false);
        this.closed = true;
        this.sessionHandleState.notifySessionClosed();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closed.");
        }
    }

    private boolean isEnlistedInGlobalTransaction() {
        CompositeTransactionManager compositeTransactionManager = this.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            return false;
        }
        CompositeTransaction ct = compositeTransactionManager.getCompositeTransaction();
        return this.sessionHandleState.isActiveInTransaction(ct);
    }

    public static Reapable newInstance(Connection c, SessionHandleState sessionHandleState) {
        Reapable ret = null;
        AtomikosConnectionProxy proxy = new AtomikosConnectionProxy(c, sessionHandleState);
        Set interfaces = PropertyUtils.getAllImplementedInterfaces(c.getClass());
        interfaces.add(Reapable.class);
        interfaces.add(DynamicProxy.class);
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(c.getClass().getClassLoader());
        classLoaders.add(AtomikosConnectionProxy.class.getClassLoader());
        ret = (Reapable)ClassLoadingHelper.newProxyInstance(classLoaders, (Class[])MINIMUM_SET_OF_INTERFACES, (Class[])interfaceClasses, (InvocationHandler)proxy);
        return ret;
    }

    private class JdbcRequeueSynchronization
    implements Synchronization {
        private static final long serialVersionUID = 1L;
        private CompositeTransaction compositeTransaction;
        private AbstractConnectionProxy proxy;
        private boolean afterCompletionDone;

        public JdbcRequeueSynchronization(AbstractConnectionProxy proxy, CompositeTransaction compositeTransaction) {
            this.compositeTransaction = compositeTransaction;
            this.proxy = proxy;
            this.afterCompletionDone = false;
        }

        public void afterCompletion(TxState state) {
            if (this.afterCompletionDone) {
                return;
            }
            if (state.equals((Object)TxState.ABORTING)) {
                AtomikosConnectionProxy.this.forceCloseAllPendingStatements(true);
            }
            if (state.equals((Object)TxState.TERMINATED) || state.isHeuristic()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(this.proxy + ": detected termination of transaction " + this.compositeTransaction);
                }
                AtomikosConnectionProxy.this.sessionHandleState.notifyTransactionTerminated(this.compositeTransaction);
                this.afterCompletionDone = true;
                AtomikosConnectionProxy.this.forceCloseAllPendingStatements(false);
            }
        }

        public void beforeCompletion() {
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof JdbcRequeueSynchronization) {
                JdbcRequeueSynchronization o = (JdbcRequeueSynchronization)other;
                ret = this.compositeTransaction.isSameTransaction(o.compositeTransaction);
            }
            return ret;
        }

        public int hashCode() {
            return this.compositeTransaction.hashCode();
        }
    }
}

