/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.jdbc.ConnectionFactory;
import com.atomikos.jdbc.ExclusiveExternalXAPooledConnectionImp;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import com.atomikos.jdbc.XPooledConnection;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class XAConnectionFactory
implements ConnectionFactory {
    private String userName_;
    private String passwd_;
    private String resourceName_;
    private XADataSource ds_;
    private JdbcTransactionalResource res_;
    private boolean exclusive_;

    protected XAConnectionFactory(String resourceName, String userName, String passwd, XADataSource xaDataSource, JdbcTransactionalResource res) {
        this.resourceName_ = resourceName;
        this.userName_ = userName;
        this.passwd_ = passwd;
        this.ds_ = xaDataSource;
        this.res_ = res;
        if (userName != null && !userName.equals("")) {
            this.res_.setUser(userName);
            this.res_.setPassword(passwd);
        }
        this.exclusive_ = false;
    }

    public XAConnectionFactory(String resourceName, String userName, String passwd, XADataSource xaDataSource) {
        this.resourceName_ = resourceName;
        this.userName_ = userName;
        this.passwd_ = passwd;
        this.ds_ = xaDataSource;
        this.res_ = new JdbcTransactionalResource(resourceName, this.ds_);
        this.res_.setUser(userName);
        this.res_.setPassword(passwd);
        this.exclusive_ = false;
    }

    public XAConnectionFactory(String resourceName, String userName, String passwd, XADataSource xaDataSource, XidFactory xidFactory) {
        this.resourceName_ = resourceName;
        this.userName_ = userName;
        this.passwd_ = passwd;
        this.ds_ = xaDataSource;
        this.res_ = new JdbcTransactionalResource(resourceName, this.ds_, xidFactory);
        this.res_.setUser(userName);
        this.res_.setPassword(passwd);
        this.exclusive_ = false;
    }

    protected String getUserName() {
        return this.userName_;
    }

    protected String getPassword() {
        return this.passwd_;
    }

    public XADataSource getXADataSource() {
        return this.ds_;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive_ = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusive_;
    }

    public TransactionalResource getTransactionalResource() {
        return this.res_;
    }

    public XPooledConnection getPooledConnection() throws IllegalStateException, SQLException {
        XAConnection conn = null;
        ExternalXAPooledConnectionImp ret = null;
        if (this.getTransactionalResource() == null) {
            throw new IllegalStateException("XAConnectionFactory: no tx resource");
        }
        conn = this.getUserName() == null || this.getUserName().equals("") ? this.getXADataSource().getXAConnection() : this.getXADataSource().getXAConnection(this.getUserName(), this.getPassword());
        ret = !this.exclusive_ ? new ExternalXAPooledConnectionImp(conn, this.getTransactionalResource(), this.getLogWriter()) : new ExclusiveExternalXAPooledConnectionImp(conn, this.getTransactionalResource(), this.getLogWriter());
        return ret;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getXADataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.getXADataSource().setLogWriter(pw);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getXADataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int secs) throws SQLException {
        this.getXADataSource().setLoginTimeout(secs);
    }
}

