/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.BeanInspector;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.DataSourceShutdownHook;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.JtaDataSourceImp;
import com.atomikos.jdbc.XAConnectionFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.SerializableObjectFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SimpleDataSourceBean
implements HeuristicDataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable {
    private transient JtaDataSourceImp ds_ = null;
    private transient XADataSource xads_ = null;
    private String resourceName_ = "someUniqueName";
    private String xidFactory_ = "Default";
    private int poolSize_ = 1;
    private int connectionTimeout_ = 30;
    private boolean exclusive_ = true;
    private String validatingQuery_ = "";
    private String xaProperties_ = "";
    private String xaDataSourceClassName_ = "";
    private boolean testOnBorrow_ = false;

    private Properties parseProperties() {
        Properties ret = new Properties();
        StringTokenizer t = new StringTokenizer(this.xaProperties_, ";");
        if (this.xaProperties_.indexOf(",") >= 0) {
            Configuration.logWarning((String)("xaDataSourceProperties: found comma(s) - please make sure to use ';' to separate properties: " + this.xaProperties_));
        } else if (t.countTokens() <= 1) {
            Configuration.logWarning((String)("xaDataSourceProperties: only one property found - please check format: " + this.xaProperties_));
        }
        while (t.hasMoreTokens()) {
            String next = t.nextToken();
            int index = next.indexOf("=");
            if (index < 0) {
                throw new RuntimeException("Invalid xaDataSourceProperties format");
            }
            String name = next.substring(0, index);
            String val = next.substring(index + 1);
            ret.setProperty(name, val);
        }
        return ret;
    }

    private synchronized void checkSetup(boolean validation) throws SQLException {
        this.ds_ = JtaDataSourceImp.getInstance(this.getUniqueResourceName());
        if (this.ds_ != null && !validation) {
            return;
        }
        if (this.xads_ == null && (this.getXaDataSourceClassName() == null || this.getXaDataSourceClassName().length() == 0)) {
            throw new SQLException("SimpleDataSourceBean: xaDataSourceClassName not set.");
        }
        if (this.xidFactory_ == null) {
            throw new SQLException("SimpleDataSourceBean: xidFormat not set.");
        }
        if (this.xads_ == null) {
            try {
                Class xadsClass = ClassLoadingHelper.loadClass((String)this.getXaDataSourceClassName());
                this.xads_ = (XADataSource)xadsClass.newInstance();
                BeanInspector inspector = new BeanInspector((Object)this.xads_);
                Properties p = this.parseProperties();
                Enumeration<?> names = p.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String val = p.getProperty(name);
                    inspector.setPropertyValue(name, val);
                }
            }
            catch (Exception e) {
                Configuration.logWarning((String)("SimpleDataSourceBean: could not configure XADataSource of class " + this.getXaDataSourceClassName()), (Throwable)e);
                throw new SQLException("Could not configure XADataSource: " + e.getMessage() + " " + e.getClass().getName());
            }
        }
        DefaultXidFactory xidFactory = null;
        xidFactory = new DefaultXidFactory();
        XAConnectionFactory factory = new XAConnectionFactory(this.resourceName_, "", "", this.xads_, (XidFactory)xidFactory);
        factory.setExclusive(this.exclusive_);
        this.ds_ = new JtaDataSourceImp(factory, this.poolSize_, this.connectionTimeout_, validation, !validation, this.validatingQuery_, this.testOnBorrow_);
        DataSourceShutdownHook hook = new DataSourceShutdownHook(this.ds_);
        Configuration.addShutdownHook((Thread)hook);
        StringBuffer sb = new StringBuffer();
        sb.append("SimpleDataSourceBean configured with [");
        sb.append("resourceName=").append(this.resourceName_).append(", ");
        sb.append("xidFactory=").append(this.xidFactory_).append(", ");
        sb.append("poolSize=").append(this.poolSize_).append(", ");
        sb.append("connectionTimeout=").append(this.connectionTimeout_).append(", ");
        sb.append("exclusive=").append(this.exclusive_).append(", ");
        sb.append("validatingQuery=").append(this.validatingQuery_).append(", ");
        sb.append("xaProperties=").append(this.xaProperties_).append(", ");
        sb.append("xaDataSourceClassName=").append(this.xaDataSourceClassName_).append(", ");
        sb.append("testOnBorrow=").append(this.testOnBorrow_);
        sb.append("]");
        Configuration.logDebug((String)sb.toString());
        Configuration.logWarning((String)("WARNING: class " + this.getClass().getName() + " is deprecated!"));
    }

    private synchronized void checkSetup() throws SQLException {
        this.checkSetup(false);
    }

    public void init() throws SQLException {
        this.checkSetup(false);
    }

    public void setUniqueResourceName(String resourceName) {
        this.resourceName_ = resourceName;
    }

    public String getUniqueResourceName() {
        return this.resourceName_;
    }

    public void setConnectionPoolSize(int poolSize) {
        this.poolSize_ = poolSize;
    }

    public int getConnectionPoolSize() {
        return this.poolSize_;
    }

    public void setTestOnBorrow(boolean value) {
        this.testOnBorrow_ = value;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow_;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout_ = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout_;
    }

    public void setExclusiveConnectionMode(boolean mode) {
        this.exclusive_ = mode;
    }

    public boolean getExclusiveConnectionMode() {
        return this.exclusive_;
    }

    protected TransactionalResource getTransactionalResource() {
        try {
            this.checkSetup();
        }
        catch (SQLException err) {
            err.printStackTrace();
            throw new RuntimeException(err.getMessage());
        }
        return this.ds_.getTransactionalResource();
    }

    public void setValidatingQuery(String query) {
        this.validatingQuery_ = query;
    }

    public String getValidatingQuery() {
        return this.validatingQuery_;
    }

    public void setXaDataSourceClassName(String name) {
        this.xaDataSourceClassName_ = name;
    }

    public String getXaDataSourceClassName() {
        String ret = this.xaDataSourceClassName_;
        if (ret == null && this.xads_ != null) {
            ret = this.xads_.getClass().getName();
        }
        return ret;
    }

    public void setXaDataSourceProperties(String properties) {
        this.xaProperties_ = properties;
    }

    public String getXaDataSourceProperties() {
        StringBuffer ret = new StringBuffer();
        if (this.xaProperties_ != null) {
            ret.append(this.xaProperties_);
        }
        if (ret.length() == 0 && this.xads_ != null) {
            try {
                BeanInspector inspector = new BeanInspector((Object)this.xads_);
                Property[] props = inspector.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    String name = props[i].getName();
                    String value = inspector.getPropertyValue(name);
                    ret.append(name);
                    ret.append("=");
                    ret.append(value);
                    if (i >= props.length - 1) continue;
                    ret.append(";");
                }
            }
            catch (PropertyException e) {
                Configuration.logWarning((String)"Error in getXaDataSourceProperties", (Throwable)e);
                throw new UndeclaredThrowableException(e);
            }
        }
        return ret.toString();
    }

    public void setXaDataSource(XADataSource xads) {
        this.xads_ = xads;
    }

    public XADataSource getXaDataSource() {
        return this.xads_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String query = this.getValidatingQuery();
        if (query == null || query.equals("")) {
            return;
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds_.getConnection();
            try {
                s = c.createStatement();
                ResultSet rs = s.executeQuery(query);
                s.close();
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (SQLException e) {
            Configuration.logWarning((String)("Error in validating query for resource " + this.getUniqueResourceName()), (Throwable)e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection();
    }

    public Connection getConnection(String user, String pw) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(user, pw);
    }

    public Connection getConnection(HeuristicMessage msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(msg);
    }

    public Connection getConnection(String user, String pw, HeuristicMessage msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(user, pw, msg);
    }

    public Connection getConnection(String msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(msg);
    }

    public Connection getConnection(String user, String passwd, String msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(user, passwd, msg);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup();
        return this.ds_.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup();
        return this.ds_.getLogWriter();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.checkSetup();
        this.ds_.setLoginTimeout(seconds);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.checkSetup();
        this.ds_.setLogWriter(out);
    }

    public void close() throws SQLException {
        if (this.ds_ != null) {
            this.ds_.close();
        }
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        this.checkSetup();
        ExternalXAPooledConnectionImp ret = null;
        XAConnection xaconn = this.xads_.getXAConnection();
        ret = new ExternalXAPooledConnectionImp(xaconn, this.getTransactionalResource(), this.getLogWriter());
        return ret;
    }

    public PooledConnection getPooledConnection(String user, String pw) throws SQLException {
        ExternalXAPooledConnectionImp ret = null;
        this.checkSetup();
        XAConnection xaconn = this.xads_.getXAConnection(user, pw);
        ret = new ExternalXAPooledConnectionImp(xaconn, this.getTransactionalResource(), this.getLogWriter());
        return ret;
    }
}

