/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery;

import com.atomikos.recovery.ParticipantLogEntry;
import com.atomikos.recovery.TxState;
import java.io.Serializable;

public class CoordinatorLogEntry
implements Serializable {
    private static final long serialVersionUID = -919666492191340531L;
    public final String id;
    public final boolean wasCommitted;
    public final String superiorCoordinatorId;
    public final ParticipantLogEntry[] participants;

    private CoordinatorLogEntry(CoordinatorLogEntry toCopy, ParticipantLogEntry participantLogEntry) {
        this(toCopy.id, toCopy.wasCommitted, CoordinatorLogEntry.copy(toCopy.participants, participantLogEntry));
    }

    private static ParticipantLogEntry[] copy(ParticipantLogEntry[] origin, ParticipantLogEntry toUpdate) {
        ParticipantLogEntry[] ret = new ParticipantLogEntry[origin.length];
        for (int i = 0; i < origin.length; ++i) {
            ParticipantLogEntry participantLogEntry = origin[i];
            ret[i] = participantLogEntry.equals(toUpdate) ? toUpdate : new ParticipantLogEntry(participantLogEntry.coordinatorId, participantLogEntry.uri, participantLogEntry.expires, participantLogEntry.resourceName, participantLogEntry.state);
        }
        return ret;
    }

    public CoordinatorLogEntry(String coordinatorId, ParticipantLogEntry[] participantDetails) {
        this(coordinatorId, false, participantDetails, null);
    }

    public CoordinatorLogEntry(String coordinatorId, boolean wasCommitted, ParticipantLogEntry[] participants) {
        this.id = coordinatorId;
        this.wasCommitted = wasCommitted;
        this.participants = participants;
        this.superiorCoordinatorId = null;
    }

    public CoordinatorLogEntry(String coordinatorId, boolean wasCommitted, ParticipantLogEntry[] participants, String superiorCoordinatorId) {
        this.id = coordinatorId;
        this.wasCommitted = wasCommitted;
        this.participants = participants;
        this.superiorCoordinatorId = superiorCoordinatorId;
    }

    public TxState getResultingState() {
        if (this.oneParticipantInState(TxState.COMMITTING)) {
            return TxState.COMMITTING;
        }
        if (this.oneParticipantInState(TxState.ABORTING)) {
            return TxState.ABORTING;
        }
        if (this.allParticipantsInState(TxState.TERMINATED)) {
            return TxState.TERMINATED;
        }
        if (this.allParticipantsInState(TxState.HEUR_HAZARD)) {
            return TxState.HEUR_HAZARD;
        }
        if (this.allParticipantsInState(TxState.HEUR_ABORTED)) {
            return TxState.HEUR_ABORTED;
        }
        if (this.allParticipantsInState(TxState.HEUR_COMMITTED)) {
            return TxState.HEUR_COMMITTED;
        }
        if (this.allParticipantsInState(TxState.IN_DOUBT)) {
            return TxState.IN_DOUBT;
        }
        return TxState.HEUR_MIXED;
    }

    private boolean allParticipantsInState(TxState state) {
        for (ParticipantLogEntry participantLogEntry : this.participants) {
            if (participantLogEntry.state == state) continue;
            return false;
        }
        return true;
    }

    private boolean oneParticipantInState(TxState state) {
        for (ParticipantLogEntry ParticipantLogEntry2 : this.participants) {
            if (ParticipantLogEntry2.state != state) continue;
            return true;
        }
        return false;
    }

    public boolean transitionAllowedFrom(CoordinatorLogEntry existing) {
        TxState thisState = this.getResultingState();
        if (existing == null) {
            return thisState.isOneOf(TxState.COMMITTING, TxState.IN_DOUBT, TxState.TERMINATED);
        }
        return existing.getResultingState().transitionAllowedTo(thisState);
    }

    public CoordinatorLogEntry presumedAborting(ParticipantLogEntry entry) throws IllegalStateException {
        if (!this.getResultingState().transitionAllowedTo(TxState.ABORTING)) {
            throw new IllegalStateException();
        }
        if (this.expires() > System.currentTimeMillis()) {
            throw new IllegalStateException();
        }
        CoordinatorLogEntry ret = new CoordinatorLogEntry(this, new ParticipantLogEntry(entry.coordinatorId, entry.uri, this.expires(), entry.resourceName, TxState.ABORTING));
        return ret;
    }

    public long expires() {
        long expires = Long.MAX_VALUE;
        for (ParticipantLogEntry participant : this.participants) {
            expires = Math.min(expires, participant.expires);
        }
        return expires;
    }

    public CoordinatorLogEntry terminated(ParticipantLogEntry entry) {
        CoordinatorLogEntry ret = new CoordinatorLogEntry(this, new ParticipantLogEntry(entry.coordinatorId, entry.uri, entry.expires, entry.resourceName, TxState.TERMINATED));
        return ret;
    }

    public CoordinatorLogEntry terminatedWithHeuristicCommit(ParticipantLogEntry entry) {
        CoordinatorLogEntry ret = new CoordinatorLogEntry(this, new ParticipantLogEntry(entry.coordinatorId, entry.uri, entry.expires, entry.resourceName, TxState.HEUR_COMMITTED));
        return ret;
    }

    public CoordinatorLogEntry terminatedWithHeuristicMixed(ParticipantLogEntry entry) {
        CoordinatorLogEntry ret = new CoordinatorLogEntry(this, new ParticipantLogEntry(entry.coordinatorId, entry.uri, entry.expires, entry.resourceName, TxState.HEUR_MIXED));
        return ret;
    }

    public CoordinatorLogEntry terminatedWithHeuristicRollback(ParticipantLogEntry entry) {
        CoordinatorLogEntry ret = new CoordinatorLogEntry(this, new ParticipantLogEntry(entry.coordinatorId, entry.uri, entry.expires, entry.resourceName, TxState.HEUR_ABORTED));
        return ret;
    }

    public boolean shouldSync() {
        TxState state = this.getResultingState();
        switch (state) {
            case IN_DOUBT: 
            case ABORTING: 
            case TERMINATED: {
                return false;
            }
            case COMMITTING: {
                return this.participants.length > 1;
            }
        }
        return !state.isFinalState();
    }

    public CoordinatorLogEntry markAsTerminated() {
        CoordinatorLogEntry coordinatorLogEntry = this;
        for (ParticipantLogEntry participantLogEntry : this.participants) {
            coordinatorLogEntry = coordinatorLogEntry.terminated(participantLogEntry);
        }
        return coordinatorLogEntry;
    }

    public boolean hasExpired() {
        return this.expires() < System.currentTimeMillis();
    }

    public String toString() {
        return "CoordinatorLogEntry [id=" + this.id + ", wasCommitted=" + this.wasCommitted + ", state=" + (Object)((Object)this.getResultingState()) + "]";
    }
}

