/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SysException
extends RuntimeException {
    private Stack myErrors = null;

    private static void printNestedErrorStack(SysException sysException) {
        Stack stack = sysException.getErrors();
        while (stack != null && !stack.empty()) {
            System.err.println("Nested exception is: ");
            Exception exception = (Exception)stack.pop();
            if (exception instanceof SysException) {
                SysException sysException2 = (SysException)exception;
                exception.printStackTrace();
                SysException.printNestedErrorStack(sysException2);
                continue;
            }
            exception.printStackTrace();
        }
    }

    private static void addStackTraceElementsToList(StackTraceElement[] stackTraceElementArray, List list) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            list.add(stackTraceElementArray[i]);
        }
    }

    public SysException(String string) {
        super(string);
    }

    public SysException(String string, Stack stack) {
        super(string);
        this.myErrors = (Stack)stack.clone();
    }

    private void addStackTraceToList(List list) {
        StackTraceElement[] stackTraceElementArray = super.getStackTrace();
        SysException.addStackTraceElementsToList(stackTraceElementArray, list);
        Stack stack = this.getErrors();
        while (stack != null && !stack.empty()) {
            Exception exception = (Exception)stack.pop();
            if (exception instanceof SysException) {
                SysException sysException = (SysException)exception;
                sysException.addStackTraceToList(list);
                continue;
            }
            stackTraceElementArray = exception.getStackTrace();
            SysException.addStackTraceElementsToList(stackTraceElementArray, list);
        }
    }

    public Stack getErrors() {
        if (this.myErrors == null) {
            return null;
        }
        return (Stack)this.myErrors.clone();
    }

    public void printStackTrace() {
        super.printStackTrace();
        SysException.printNestedErrorStack(this);
    }

    public StackTraceElement[] getStackTrace() {
        ArrayList arrayList = new ArrayList();
        this.addStackTraceToList(arrayList);
        return arrayList.toArray(new StackTraceElement[0]);
    }
}

