/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;

public class VersionedFile {
    private String baseDir;
    private String suffix;
    private String baseName;
    private long version;
    private FileInputStream inputStream;
    private FileOutputStream outputStream;

    public VersionedFile(String baseDir, String baseName, String suffix) {
        this.baseDir = baseDir;
        this.suffix = suffix;
        this.baseName = baseName;
        this.resetVersion();
    }

    private void resetVersion() {
        this.version = this.extractLastValidVersionNumberFromFileNames();
    }

    private long extractLastValidVersionNumberFromFileNames() {
        long version = -1L;
        File cd = new File(this.getBaseDir());
        String[] names = cd.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(VersionedFile.this.getBaseName()) && name.endsWith(VersionedFile.this.getSuffix());
            }
        });
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                long sfx = this.extractVersion(names[i]);
                if (version >= 0L && sfx >= version) continue;
                version = sfx;
            }
        }
        return version;
    }

    private long extractVersion(String name) {
        long ret = 0L;
        int lastpos = name.lastIndexOf(46);
        int startpos = this.getBaseName().length();
        String suffix = name.substring(startpos, lastpos);
        try {
            ret = Long.valueOf(suffix);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException err = new IllegalArgumentException("Error extracting version from file: " + name);
            err.initCause(e);
            throw err;
        }
        return ret;
    }

    private String getBackupVersionFileName() {
        return this.getBaseUrl() + (this.version - 1L) + this.getSuffix();
    }

    public String getCurrentVersionFileName() {
        return this.getBaseUrl() + this.version + this.getSuffix();
    }

    public String getBaseUrl() {
        return this.baseDir + this.baseName;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public FileInputStream openLastValidVersionForReading() throws IllegalStateException, FileNotFoundException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Already started writing.");
        }
        this.inputStream = new FileInputStream(this.getCurrentVersionFileName());
        return this.inputStream;
    }

    public FileOutputStream openNewVersionForWriting() throws FileNotFoundException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Already writing a new version.");
        }
        ++this.version;
        this.outputStream = new FileOutputStream(this.getCurrentVersionFileName());
        return this.outputStream;
    }

    public void discardBackupVersion() throws IllegalStateException, IOException {
        if (this.outputStream == null) {
            throw new IllegalStateException("No new version yet!");
        }
        String fileName = this.getBackupVersionFileName();
        File temp = new File(fileName);
        if (temp.exists() && !temp.delete()) {
            throw new IOException("Failed to delete backup version: " + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.resetVersion();
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.outputStream != null) {
            try {
                if (this.outputStream.getFD().valid()) {
                    this.outputStream.close();
                }
            }
            finally {
                this.outputStream = null;
            }
        }
    }

    public long getSize() {
        long res = -1L;
        File f = new File(this.getCurrentVersionFileName());
        res = f.length();
        return res;
    }
}

