/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.AbstractPropertyEditorComponent;
import com.atomikos.beans.PrimitiveClasses;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TextFieldComponent
extends AbstractPropertyEditorComponent
implements CaretListener {
    private JTextField text_;
    private JPanel panel_;
    private Property property_;
    private boolean decimal_;

    public TextFieldComponent(Property property) throws PropertyException {
        this.property_ = property;
        this.panel_ = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panel_.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(property.getName());
        this.text_ = new JTextField(10);
        gridBagLayout.setConstraints(this.text_, gridBagConstraints);
        this.text_.setToolTipText(property.getDescription());
        this.panel_.add(this.text_);
        this.text_.addCaretListener(this);
    }

    public TextFieldComponent(Property property, boolean bl) throws PropertyException {
        this(property);
        this.decimal_ = bl;
        this.text_.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!(Character.isDigit(c) || c == '\b' || c == '\u007f' || c == '.' && TextFieldComponent.this.decimal_)) {
                    keyEvent.consume();
                    TextFieldComponent.this.panel_.getToolkit().beep();
                }
            }
        });
    }

    public Component getComponent() {
        try {
            this.text_.setText(this.property_.getEditor().getStringValue());
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return this.panel_;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Class clazz = PrimitiveClasses.getWrapperClass(this.property_.getType());
        try {
            if (clazz == null) {
                this.getPropertyEditor().setAsText(this.text_.getText());
            } else {
                Object object = PrimitiveClasses.createWrapperObject(this.text_.getText(), this.property_.getType());
                this.getPropertyEditor().setValue(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.text_.getText() == null || this.text_.getText().equals("")) {
            return;
        }
        Class clazz = PrimitiveClasses.getWrapperClass(this.property_.getType());
        try {
            if (clazz == null) {
                this.getPropertyEditor().setAsText(this.text_.getText());
            } else {
                Object object = PrimitiveClasses.createWrapperObject(this.text_.getText(), this.property_.getType());
                this.getPropertyEditor().setValue(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

