/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.json;

import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts2.StrutsException;

public class JSONResult
implements Result {
    private static final Logger LOG = Logger.getLogger(JSONResult.class);
    private String jsonObjectProperty = "jsonObject";
    private String contentType = "application/json";

    public String getJSONObjectProperty() {
        return this.jsonObjectProperty;
    }

    public void setJSONObjectProperty(String jsonObject) {
        this.jsonObjectProperty = jsonObject;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        JSONObject jsonObject;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"executing JSONResult");
        }
        if ((jsonObject = this.getJSONObject(invocation)) != null) {
            String json = jsonObject.toString();
            HttpServletResponse response = this.getServletResponse(invocation);
            Charset charset = StandardCharsets.UTF_8;
            byte[] content = json.getBytes(charset.name());
            response.setContentType(this.getContentType() + ";charset=" + charset.name());
            response.setContentLength(content.length);
            ServletOutputStream os = response.getOutputStream();
            os.write(content);
            os.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("written [" + json + "] to HttpServletResponse outputstream"));
            }
        }
    }

    protected JSONObject getJSONObject(ActionInvocation invocation) throws JSONException {
        ActionContext actionContext = invocation.getInvocationContext();
        Object obj = actionContext.getValueStack().findValue(this.jsonObjectProperty, true);
        if (obj == null) {
            LOG.error((Object)("property [" + this.jsonObjectProperty + "] returns null, expecting JSONObject"), (Throwable)new StrutsException());
            return null;
        }
        if (!JSONObject.class.isInstance(obj)) {
            LOG.error((Object)("property [" + this.jsonObjectProperty + "] is [" + obj + "] especting an instance of JSONObject"), (Throwable)new StrutsException());
            return null;
        }
        return (JSONObject)obj;
    }

    protected HttpServletResponse getServletResponse(ActionInvocation invocation) {
        return (HttpServletResponse)invocation.getInvocationContext().getContextMap().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
    }
}

