/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest.history;

import com.atlassian.webhooks.history.HistoricalInvocation;
import com.atlassian.webhooks.history.InvocationHistory;
import com.atlassian.webhooks.internal.rest.history.RestHistoricalInvocation;
import com.atlassian.webhooks.internal.rest.history.RestInvocationCounts;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;

@JsonSerialize
public class RestInvocationHistory
extends LinkedHashMap<String, Object> {
    public static RestInvocationHistory EXAMPLE = new RestInvocationHistory(RestHistoricalInvocation.EXAMPLE_SUCCESS, RestHistoricalInvocation.EXAMPLE_FAILURE, RestHistoricalInvocation.EXAMPLE_ERROR, 100);
    private final String COUNTS = "counts";
    private final String LAST_ERROR = "lastError";
    private final String LAST_FAILURE = "lastFailure";
    private final String LAST_SUCCESS = "lastSuccess";

    public RestInvocationHistory() {
    }

    public RestInvocationHistory(@Nonnull InvocationHistory history) {
        history.getLastError().ifPresent(lastError -> this.put("lastError", new RestHistoricalInvocation((HistoricalInvocation)lastError)));
        history.getLastFailure().ifPresent(lastFail -> this.put("lastFailure", new RestHistoricalInvocation((HistoricalInvocation)lastFail)));
        history.getLastSuccess().ifPresent(lastSuccess -> this.put("lastSuccess", new RestHistoricalInvocation((HistoricalInvocation)lastSuccess)));
        this.put("counts", new RestInvocationCounts(history.getCounts()));
    }

    private RestInvocationHistory(RestHistoricalInvocation success, RestHistoricalInvocation failure, RestHistoricalInvocation error, int counts) {
        this.put("lastSuccess", success);
        this.put("lastFailure", failure);
        this.put("lastError", error);
        this.put("counts", counts);
    }
}

