/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.rest.history;

import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.history.HistoricalInvocation;
import com.atlassian.webhooks.internal.rest.RestWebhookScope;
import com.atlassian.webhooks.internal.rest.history.RestInvocationRequest;
import com.atlassian.webhooks.internal.rest.history.RestInvocationResult;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.Nonnull;

@JsonSerialize
public class RestHistoricalInvocation
extends LinkedHashMap<String, Object> {
    public static final RestHistoricalInvocation EXAMPLE_ERROR = new RestHistoricalInvocation(12, "repo:modified", RestWebhookScope.EXAMPLE, 100, 1513106011, 1513106111, RestInvocationRequest.EXAMPLE, RestInvocationResult.EXAMPLE_ERROR);
    public static final RestHistoricalInvocation EXAMPLE_FAILURE = new RestHistoricalInvocation(11, "repo:refs_changed", RestWebhookScope.EXAMPLE, 100, 1513106011, 1513106111, RestInvocationRequest.EXAMPLE, RestInvocationResult.EXAMPLE_FAILURE);
    public static final RestHistoricalInvocation EXAMPLE_SUCCESS = new RestHistoricalInvocation(10, "repo:created", RestWebhookScope.EXAMPLE, 155, 1513106011, 1513106166, RestInvocationRequest.EXAMPLE, RestInvocationResult.EXAMPLE);
    private final String DURATION = "duration";
    private final String EVENT = "event";
    private final String EVENT_SCOPE = "eventScope";
    private final String FINISH = "finish";
    private final String ID = "id";
    private final String REQUEST = "request";
    private final String RESULT = "result";
    private final String START = "start";

    public RestHistoricalInvocation() {
    }

    public RestHistoricalInvocation(@Nonnull HistoricalInvocation invocation) {
        this.put("id", invocation.getId());
        this.put("event", invocation.getEvent().getId());
        invocation.getEventScope().ifPresent(eventScope -> this.put("eventScope", new RestWebhookScope((WebhookScope)eventScope)));
        this.put("duration", invocation.getDuration().toMillis());
        this.put("start", invocation.getStart().toEpochMilli());
        this.put("finish", invocation.getFinish().toEpochMilli());
        this.putRequest(invocation);
        this.putResponse(invocation);
    }

    private RestHistoricalInvocation(int id, String event, RestWebhookScope eventScope, int duration, int start, int finish, RestInvocationRequest request, RestInvocationResult result) {
        this.put("id", id);
        this.put("event", event);
        this.put("eventScope", eventScope);
        this.put("duration", duration);
        this.put("start", start);
        this.put("finish", finish);
        this.put("request", request);
        this.put("result", result);
    }

    public int getDuration() {
        return this.getIntProperty("duration");
    }

    public String getEvent() {
        return this.getStringProperty("event");
    }

    public RestWebhookScope getEventScope() {
        return RestWebhookScope.valueOf(this.get("eventScope"));
    }

    public int getFinish() {
        return this.getIntProperty("finish");
    }

    public int getId() {
        return this.getIntProperty("id");
    }

    public RestInvocationRequest getRequest() {
        return RestInvocationRequest.valueOf("request");
    }

    public RestInvocationResult getResult() {
        return RestInvocationResult.valueOf("result");
    }

    public int getStart() {
        return this.getIntProperty("start");
    }

    protected void putRequest(@Nonnull HistoricalInvocation invocation) {
        this.put("request", new RestInvocationRequest(invocation.getRequest()));
    }

    protected void putResponse(@Nonnull HistoricalInvocation invocation) {
        this.put("result", new RestInvocationResult(invocation.getResult()));
    }

    private int getIntProperty(String property) {
        return this.getOptionalIntProperty(property).orElse(-1);
    }

    private OptionalInt getOptionalIntProperty(String property) {
        Object value = this.get(property);
        if (value instanceof Number) {
            return OptionalInt.of(((Number)value).intValue());
        }
        if (value instanceof String) {
            return OptionalInt.of(Integer.parseInt((String)value));
        }
        return OptionalInt.empty();
    }

    private String getStringProperty(String key) {
        return Objects.toString(this.get(key), null);
    }
}

