/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks;

import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookCallback;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.util.BuilderUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class WebhookPublishRequest {
    private final List<WebhookCallback> callbacks;
    private final Map<String, Object> context;
    private final WebhookEvent event;
    private final Supplier<?> payloadSupplier;
    private WebhookScope eventScope;
    private List<WebhookScope> scopes;
    private Webhook webhook;
    private Optional<Runnable> invocationCompletedCallback;

    private WebhookPublishRequest(SearchBuilder searchBuilder) {
        this.callbacks = searchBuilder.callbacks;
        this.context = searchBuilder.context;
        this.event = searchBuilder.event;
        this.eventScope = searchBuilder.eventScope;
        this.scopes = searchBuilder.scopes;
        this.payloadSupplier = searchBuilder.payloadSupplier;
        this.invocationCompletedCallback = searchBuilder.invocationCompletedCallback;
    }

    private WebhookPublishRequest(SingleWebhookBuilder singleWebhookBuilder) {
        this.callbacks = singleWebhookBuilder.callbacks;
        this.context = singleWebhookBuilder.context;
        this.event = singleWebhookBuilder.event;
        this.payloadSupplier = singleWebhookBuilder.payloadSupplier;
        this.webhook = singleWebhookBuilder.webhook;
        this.eventScope = singleWebhookBuilder.eventScope;
        this.invocationCompletedCallback = singleWebhookBuilder.invocationCompletedCallback;
    }

    @Nonnull
    public static SearchBuilder builder(@Nonnull WebhookEvent event, @Nullable Object payload) {
        return WebhookPublishRequest.builder(event, payload, Collections.emptyMap());
    }

    @Nonnull
    public static SearchBuilder builder(@Nonnull WebhookEvent event, @Nullable Supplier<?> payloadSupplier) {
        return WebhookPublishRequest.builder(event, payloadSupplier, Collections.emptyMap());
    }

    @Nonnull
    public static SearchBuilder builder(@Nonnull WebhookEvent event, @Nullable Object payload, @Nonnull Map<String, Object> context) {
        return new SearchBuilder(event, payload, context);
    }

    @Nonnull
    public static SearchBuilder builder(@Nonnull WebhookEvent event, @Nullable Supplier<?> payloadSupplier, @Nonnull Map<String, Object> context) {
        return new SearchBuilder(event, payloadSupplier, context);
    }

    @Nonnull
    public static SingleWebhookBuilder builder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Object payload) {
        return WebhookPublishRequest.builder(webhook, event, payload, Collections.emptyMap());
    }

    @Nonnull
    public static SingleWebhookBuilder builder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Supplier<?> payloadSupplier) {
        return WebhookPublishRequest.builder(webhook, event, payloadSupplier, Collections.emptyMap());
    }

    @Nonnull
    public static SingleWebhookBuilder builder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Object payload, @Nonnull Map<String, Object> context) {
        return new SingleWebhookBuilder(webhook, event, payload, context);
    }

    @Nonnull
    public static SingleWebhookBuilder builder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Supplier<?> payloadSupplier, @Nonnull Map<String, Object> context) {
        return new SingleWebhookBuilder(webhook, event, payloadSupplier, context);
    }

    @Nonnull
    public List<WebhookCallback> getCallbacks() {
        return this.callbacks;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @NotNull
    public WebhookEvent getEvent() {
        return this.event;
    }

    @Nonnull
    public Optional<WebhookScope> getEventScope() {
        return Optional.ofNullable(this.eventScope);
    }

    @Nonnull
    public Optional<Object> getPayload() {
        Object payload = Optional.ofNullable(this.payloadSupplier).map(Supplier::get).orElse(null);
        return Optional.ofNullable(payload);
    }

    @Nonnull
    public List<WebhookScope> getScopes() {
        return this.scopes;
    }

    @Nonnull
    public Optional<Webhook> getWebhook() {
        return Optional.ofNullable(this.webhook);
    }

    public Optional<Runnable> getInvocationCompletedCallback() {
        return this.invocationCompletedCallback;
    }

    public static class SearchBuilder {
        private final List<WebhookCallback> callbacks;
        private final Map<String, Object> context;
        private final Supplier<?> payloadSupplier;
        private final List<WebhookScope> scopes;
        private WebhookEvent event;
        private WebhookScope eventScope;
        private Optional<Runnable> invocationCompletedCallback = Optional.empty();

        public SearchBuilder(@Nonnull WebhookEvent event, @Nullable Object payload) {
            this(event, payload, Collections.emptyMap());
        }

        public SearchBuilder(@Nonnull WebhookEvent event, @Nullable Object payload, @Nonnull Map<String, Object> context) {
            this(event, () -> payload, context);
        }

        public SearchBuilder(@Nonnull WebhookEvent event, @Nullable Supplier<?> payloadSupplier, @Nonnull Map<String, Object> context) {
            this.callbacks = new ArrayList<WebhookCallback>();
            this.context = context;
            this.event = Objects.requireNonNull(event, "event");
            this.payloadSupplier = payloadSupplier;
            this.scopes = new ArrayList<WebhookScope>();
        }

        @Nonnull
        public WebhookPublishRequest build() {
            return new WebhookPublishRequest(this);
        }

        @Nonnull
        public SearchBuilder callback(@Nonnull WebhookCallback value, WebhookCallback ... values) {
            BuilderUtil.addIf(Objects::nonNull, this.callbacks, value, values);
            return this;
        }

        @Nonnull
        public SearchBuilder eventScope(@Nonnull WebhookScope value) {
            this.eventScope = value;
            return this;
        }

        @Nonnull
        public SearchBuilder scopes(@Nonnull WebhookScope value, WebhookScope ... values) {
            BuilderUtil.addIf(Objects::nonNull, this.scopes, value, values);
            return this;
        }

        @Nonnull
        public SearchBuilder invocationCompletedCallback(Runnable callback) {
            this.invocationCompletedCallback = Optional.of(callback);
            return this;
        }
    }

    public static class SingleWebhookBuilder {
        private final List<WebhookCallback> callbacks;
        private final Map<String, Object> context;
        private final WebhookEvent event;
        private final Supplier<?> payloadSupplier;
        private final Webhook webhook;
        private Optional<Runnable> invocationCompletedCallback = Optional.empty();
        private WebhookScope eventScope;

        public SingleWebhookBuilder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Object payload) {
            this(webhook, event, payload, Collections.emptyMap());
        }

        public SingleWebhookBuilder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Object payload, @Nonnull Map<String, Object> context) {
            this(webhook, event, () -> payload, context);
        }

        public SingleWebhookBuilder(@Nonnull Webhook webhook, @Nonnull WebhookEvent event, @Nullable Supplier<?> payloadSupplier, @Nonnull Map<String, Object> context) {
            this.context = Objects.requireNonNull(context, "context");
            this.event = Objects.requireNonNull(event, "event");
            this.payloadSupplier = payloadSupplier;
            this.webhook = Objects.requireNonNull(webhook, "webhook");
            this.callbacks = new ArrayList<WebhookCallback>();
        }

        @Nonnull
        public WebhookPublishRequest build() {
            return new WebhookPublishRequest(this);
        }

        @Nonnull
        public SingleWebhookBuilder callback(@Nonnull WebhookCallback value, WebhookCallback ... values) {
            BuilderUtil.addIf(Objects::nonNull, this.callbacks, value, values);
            return this;
        }

        @Nonnull
        public SingleWebhookBuilder invocationCompletedCallback(Runnable callback) {
            this.invocationCompletedCallback = Optional.of(callback);
            return this;
        }

        @Nonnull
        public SingleWebhookBuilder eventScope(@Nonnull WebhookScope value) {
            this.eventScope = value;
            return this;
        }
    }
}

