package com.atlassian.web.servlet.api;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.function.Consumer;

/**
 * Forwards requests to a location. Keeps track of the last forwarded location. The state should be thread-confined.
 *
 * @since 1.0
 */
public interface ServletForwarder {

    /**
     * Forwards the request to the specified location inside the servlet container.
     *
     * @param request  the request to forward
     * @param response the response for the forwarded location to contribute to
     * @param location the location to forward to
     * @since 1.0
     */
    void forward(HttpServletRequest request, HttpServletResponse response, URI location);
}
