package com.atlassian.web.servlet.api;

import java.io.Writer;

/**
 * Updates client-side location to the most desirable value. To achieve maximum correctness safety, this should be
 * called before the client uses <tt>window.location</tt>.
 *
 * @since 1.1
 */
public interface LocationUpdater {

    /**
     * Updates client-side location considering:
     * <ul>
     * <li>the last forwarded location</li>
     * </ul>
     *
     * @param writer writes the response to the client
     * @since 1.1
     */
    void updateLocation(Writer writer);
}
