/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.htmlsafe;

import com.atlassian.velocity.htmlsafe.HtmlSafeAnnotationUtils;
import com.atlassian.velocity.htmlsafe.introspection.MethodAnnotator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlSafeClassAnnotator
implements MethodAnnotator {
    private static final Map<String, Set<String>> HTML_ENCODE_CLASS_METHODS = new HashMap<String, Set<String>>(){
        {
            this.put("com.opensymphony.util.TextUtils", new HashSet<String>(Arrays.asList("htmlEncode")));
            this.put("org.apache.velocity.tools.generic.EscapeTool", new HashSet<String>(Arrays.asList("html")));
            this.put("com.opensymphony.webwork.util.WebWorkUtil", new HashSet<String>(Arrays.asList("htmlEncode")));
            this.put("com.opensymphony.webwork.util.VelocityWebWorkUtil", new HashSet<String>(Arrays.asList("htmlEncode")));
        }
    };

    @Override
    public Collection<Annotation> getAnnotationsForMethod(Method method) {
        if (this.safeMethodsFor(method.getDeclaringClass()).contains(method.getName())) {
            return Collections.singleton(HtmlSafeAnnotationUtils.HTML_SAFE_ANNOTATION);
        }
        return Collections.emptySet();
    }

    private Set<String> safeMethodsFor(Class<?> c) {
        if (!HTML_ENCODE_CLASS_METHODS.containsKey(c.getName())) {
            return Collections.emptySet();
        }
        return HTML_ENCODE_CLASS_METHODS.get(c.getName());
    }
}

