package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import net.spy.memcached.MemcachedClientIF;

import javax.annotation.Nonnull;
import java.util.function.Function;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Represents the settings for a {@link MemcachedVCacheService}.
 * They are created using the {@link MemcachedVCacheServiceSettingsBuilder},
 * which you should consult for the description of each property.
 *
 * @since 1.3.0
 */
public class MemcachedVCacheServiceSettings {
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final Supplier<RequestContext> contextSupplier;
    private final VCacheSettingsDefaultsProvider defaultsProvider;
    private final VCacheCreationHandler creationHandler;
    private final MetricsCollector metricsCollector;
    private final ExternalCacheKeyGenerator externalCacheKeyGenerator;
    private final BegunTransactionalActivityHandler begunTransactionalActivityHandler;
    private final Function<String, Boolean> dontExternaliseCache;

    MemcachedVCacheServiceSettings(Supplier<MemcachedClientIF> clientSupplier,
                                          Supplier<RequestContext> contextSupplier,
                                          VCacheSettingsDefaultsProvider defaultsProvider,
                                          VCacheCreationHandler creationHandler,
                                          MetricsCollector metricsCollector,
                                          ExternalCacheKeyGenerator externalCacheKeyGenerator,
                                          BegunTransactionalActivityHandler begunTransactionalActivityHandler,
                                          Function<String, Boolean> dontExternaliseCache) {
        this.clientSupplier = requireNonNull(clientSupplier);
        this.contextSupplier = requireNonNull(contextSupplier);
        this.defaultsProvider = requireNonNull(defaultsProvider);
        this.creationHandler = requireNonNull(creationHandler);
        this.metricsCollector = requireNonNull(metricsCollector);
        this.externalCacheKeyGenerator = requireNonNull(externalCacheKeyGenerator);
        this.begunTransactionalActivityHandler = requireNonNull(begunTransactionalActivityHandler);
        this.dontExternaliseCache = requireNonNull(dontExternaliseCache);
    }

    @Nonnull
    public Supplier<MemcachedClientIF> getClientSupplier() {
        return clientSupplier;
    }

    @Nonnull
    public Supplier<RequestContext> getContextSupplier() {
        return contextSupplier;
    }

    @Nonnull
    public VCacheSettingsDefaultsProvider getDefaultsProvider() {
        return defaultsProvider;
    }

    @Nonnull
    public VCacheCreationHandler getCreationHandler() {
        return creationHandler;
    }

    @Nonnull
    public MetricsCollector getMetricsCollector() {
        return metricsCollector;
    }

    @Nonnull
    public ExternalCacheKeyGenerator getExternalCacheKeyGenerator() {
        return externalCacheKeyGenerator;
    }

    @Nonnull
    public BegunTransactionalActivityHandler getBegunTransactionalActivityHandler() {
        return begunTransactionalActivityHandler;
    }

    @Nonnull
    public Function<String, Boolean> getDontExternaliseCache() {
        return dontExternaliseCache;
    }
}
