/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.ExternalCacheExceptionListener;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.Sha1ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.DefaultMetricsCollector;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettings;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.spy.memcached.MemcachedClientIF;

public class MemcachedVCacheServiceSettingsBuilder {
    private Supplier<MemcachedClientIF> clientSupplier;
    private Supplier<RequestContext> threadLocalContextSupplier;
    private Supplier<RequestContext> workContextContextSupplier;
    private VCacheSettingsDefaultsProvider defaultsProvider;
    private VCacheCreationHandler creationHandler;
    private MetricsCollector metricsCollector;
    private ExternalCacheKeyGenerator externalCacheKeyGenerator;
    private BegunTransactionalActivityHandler begunTransactionalActivityHandler = context -> {};
    private Function<String, Boolean> dontExternaliseCache = name -> false;
    private boolean serializationHack;
    private Duration lockTimeout = Duration.ofSeconds(30L);
    private ExternalCacheExceptionListener externalCacheExceptionListener = (n, ex) -> {};

    public MemcachedVCacheServiceSettingsBuilder clientSupplier(Supplier<MemcachedClientIF> clientSupplier) {
        this.clientSupplier = Objects.requireNonNull(clientSupplier);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder threadLocalContextSupplier(Supplier<RequestContext> threadLocalContextSupplier) {
        this.threadLocalContextSupplier = Objects.requireNonNull(threadLocalContextSupplier);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder workContextContextSupplier(Supplier<RequestContext> contextSupplier) {
        this.workContextContextSupplier = contextSupplier;
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder defaultsProvider(VCacheSettingsDefaultsProvider defaultsProvider) {
        this.defaultsProvider = Objects.requireNonNull(defaultsProvider);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder creationHandler(VCacheCreationHandler creationHandler) {
        this.creationHandler = Objects.requireNonNull(creationHandler);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder metricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = Objects.requireNonNull(metricsCollector);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder productIdentifier(String productIdentifier) {
        this.externalCacheKeyGenerator = new Sha1ExternalCacheKeyGenerator(productIdentifier);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder externalCacheKeyGenerator(ExternalCacheKeyGenerator externalCacheKeyGenerator) {
        this.externalCacheKeyGenerator = Objects.requireNonNull(externalCacheKeyGenerator);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder begunTransactionalActivityHandler(BegunTransactionalActivityHandler handler) {
        this.begunTransactionalActivityHandler = Objects.requireNonNull(handler);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder dontExternaliseCache(Function<String, Boolean> dontExternaliseCache) {
        this.dontExternaliseCache = Objects.requireNonNull(dontExternaliseCache);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder enableSerializationHack() {
        this.serializationHack = true;
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder lockTimeout(Duration lockTimeout) {
        this.lockTimeout = Objects.requireNonNull(lockTimeout);
        return this;
    }

    public MemcachedVCacheServiceSettingsBuilder externalCacheExceptionListener(ExternalCacheExceptionListener externalCacheExceptionListener) {
        this.externalCacheExceptionListener = Objects.requireNonNull(externalCacheExceptionListener);
        return this;
    }

    public MemcachedVCacheServiceSettings build() {
        return new MemcachedVCacheServiceSettings(Objects.requireNonNull(this.clientSupplier, "missing clientSupplier"), Objects.requireNonNull(this.threadLocalContextSupplier, "missing threadLocalContextSupplier"), Objects.requireNonNull(this.workContextContextSupplier, "missing thread safe workContextContextSupplier"), Objects.requireNonNull(this.defaultsProvider, "missing defaultsProvider"), Objects.requireNonNull(this.creationHandler, "missing creationHandler"), (MetricsCollector)(this.metricsCollector != null ? this.metricsCollector : new DefaultMetricsCollector(this.threadLocalContextSupplier)), Objects.requireNonNull(this.externalCacheKeyGenerator, "missing externalCacheKeyGenerator"), this.begunTransactionalActivityHandler, this.dontExternaliseCache, this.serializationHack, this.lockTimeout, this.externalCacheExceptionListener);
    }
}

