package com.atlassian.vcache.internal.legacy;

import com.atlassian.cache.Cache;
import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * Common utility methods that are specific for the Legacy implementation.
 *
 * @since 1.0.0
 */
class LegacyUtils {

    static boolean directPut(
            String externalKey,
            IdentifiedData identifiedData,
            PutPolicy policy,
            Cache<String, IdentifiedData> delegate,
            boolean avoidCasOps) {

        final PutPolicy convertedPolicy = avoidCasOps ? PutPolicy.PUT_ALWAYS : policy;

        switch (convertedPolicy) {
            case ADD_ONLY:
                return delegate.putIfAbsent(externalKey, identifiedData) == null;

            case PUT_ALWAYS:
                delegate.put(externalKey, identifiedData);
                return true;

            case REPLACE_ONLY:
                final IdentifiedData existingData = delegate.get(externalKey);
                return (existingData != null) && delegate.replace(externalKey, existingData, identifiedData);

            default:
                throw new IllegalArgumentException("Unknown put policy: " + convertedPolicy);
        }
    }

    static ExternalCacheException mapException(Exception ex) {
        return new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, ex);
    }

    static <V> Map<String, Optional<V>> directGetBulk(
            Set<String> externalKeys, Cache<String, IdentifiedData> delegate, Optional<MarshallingPair<V>> valueMarshalling) {
        return StreamSupport.stream(externalKeys.spliterator(), false)
                .distinct()
                .collect(Collectors.toMap(
                        Objects::requireNonNull,
                        k -> IdentifiedUtils.unmarshall(delegate.get(k), valueMarshalling)));
    }
}
