/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.legacy;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.Sha1ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.atlassian.vcache.internal.legacy.LegacyDirectExternalCache;
import com.atlassian.vcache.internal.legacy.LegacyJvmCache;
import com.atlassian.vcache.internal.legacy.LegacyServiceSettings;
import com.atlassian.vcache.internal.legacy.LegacyStableReadExternalCache;
import com.atlassian.vcache.internal.legacy.LegacyTransactionalExternalCache;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyVCacheService
extends AbstractVCacheService {
    private static final Logger log = LoggerFactory.getLogger(LegacyVCacheService.class);
    private final Supplier<CacheFactory> cacheFactorySupplier;
    private final LegacyServiceSettings serviceSettings;

    public LegacyVCacheService(String productIdentifier, Supplier<RequestContext> contextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, Supplier<CacheFactory> cacheFactorySupplier, LegacyServiceSettings serviceSettings, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        super(contextSupplier, defaultsProvider, creationHandler, metricsCollector, (ExternalCacheKeyGenerator)new Sha1ExternalCacheKeyGenerator(productIdentifier), begunTransactionalActivityHandler);
        this.cacheFactorySupplier = Objects.requireNonNull(cacheFactorySupplier);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    public LegacyVCacheService(Supplier<RequestContext> contextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, ExternalCacheKeyGenerator externalCacheKeyGenerator, Supplier<CacheFactory> cacheFactorySupplier, LegacyServiceSettings serviceSettings, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        super(contextSupplier, defaultsProvider, creationHandler, metricsCollector, externalCacheKeyGenerator, begunTransactionalActivityHandler);
        this.cacheFactorySupplier = Objects.requireNonNull(cacheFactorySupplier);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    @Nonnull
    protected Logger log() {
        return log;
    }

    @Nonnull
    protected <K, V> JvmCache<K, V> createJvmCache(String name, JvmCacheSettings settings) {
        CacheSettings legacySettings = new CacheSettingsBuilder().local().maxEntries(((Integer)settings.getMaxEntries().get()).intValue()).expireAfterAccess(((Duration)settings.getDefaultTtl().get()).toNanos(), TimeUnit.NANOSECONDS).build();
        return new LegacyJvmCache(this.cacheFactorySupplier.get().getCache(name, null, legacySettings));
    }

    @Nonnull
    protected <V> TransactionalExternalCache<V> createTransactionalExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        CacheSettings legacySettings = this.buildLegacySettings(settings);
        return new LegacyTransactionalExternalCache<V>((Cache<String, IdentifiedData>)this.cacheFactorySupplier.get().getCache(name, null, legacySettings), this.contextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshaller), this.transactionControlManager, this.serviceSettings);
    }

    @Nonnull
    protected <V> StableReadExternalCache<V> createStableReadExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        CacheSettings legacySettings = this.buildLegacySettings(settings);
        return new LegacyStableReadExternalCache<V>((Cache<String, IdentifiedData>)this.cacheFactorySupplier.get().getCache(name, null, legacySettings), this.contextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshaller), this.serviceSettings);
    }

    @Nonnull
    protected <V> DirectExternalCache<V> createDirectExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        CacheSettings legacySettings = this.buildLegacySettings(settings);
        return new LegacyDirectExternalCache<V>((Cache<String, IdentifiedData>)this.cacheFactorySupplier.get().getCache(name, null, legacySettings), this.contextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshaller), this.serviceSettings);
    }

    @Nonnull
    private CacheSettings buildLegacySettings(ExternalCacheSettings settings) {
        return new CacheSettingsBuilder().remote().maxEntries(((Integer)settings.getEntryCountHint().get()).intValue()).expireAfterAccess(((Duration)settings.getDefaultTtl().get()).toNanos(), TimeUnit.NANOSECONDS).build();
    }
}

