/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.legacy;

import com.atlassian.cache.Cache;
import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.IdentifiedValue;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCache;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.UnversionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.legacy.LegacyServiceSettings;
import com.atlassian.vcache.internal.legacy.LegacyUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyDirectExternalCache<V>
extends AbstractExternalCache<V>
implements DirectExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(LegacyDirectExternalCache.class);
    private final Cache<String, IdentifiedData> delegate;
    private final Supplier<RequestContext> contextSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Optional<Marshaller<V>> valueMarshaller;
    private final LegacyServiceSettings serviceSettings;

    LegacyDirectExternalCache(Cache<String, IdentifiedData> delegate, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, Optional<Marshaller<V>> valueMarshaller, LegacyServiceSettings serviceSettings) {
        super(delegate.getName());
        this.delegate = Objects.requireNonNull(delegate);
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshaller = Objects.requireNonNull(valueMarshaller);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    @Nonnull
    public CompletionStage<Optional<V>> get(String internalKey) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            IdentifiedData identifiedData = (IdentifiedData)this.delegate.get((Object)externalKey);
            return IdentifiedUtils.unmarshall((IdentifiedData)identifiedData, this.valueMarshaller);
        });
    }

    @Nonnull
    public CompletionStage<V> get(String internalKey, Supplier<V> supplier) {
        return this.perform(() -> {
            String externalKey = this.buildExternalKey(internalKey);
            IdentifiedData identifiedData = (IdentifiedData)this.delegate.get((Object)externalKey, () -> this.lambda$null$14((Supplier)supplier));
            return IdentifiedUtils.unmarshall((IdentifiedData)identifiedData, this.valueMarshaller).get();
        });
    }

    @Nonnull
    public CompletionStage<Optional<IdentifiedValue<V>>> getIdentified(String internalKey) {
        return this.perform(() -> {
            this.verifyCasOpsSupported();
            String externalKey = this.buildExternalKey(internalKey);
            return IdentifiedUtils.unmarshallIdentified((IdentifiedData)((IdentifiedData)this.delegate.get((Object)externalKey)), this.valueMarshaller);
        });
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<V>>> getBulk(Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return new HashMap();
            }
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            return StreamSupport.stream(internalKeys.spliterator(), false).distinct().collect(Collectors.toMap(Objects::requireNonNull, k -> IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)this.delegate.get((Object)cacheContext.externalEntryKeyFor(k))), this.valueMarshaller)));
        });
    }

    @Nonnull
    public CompletionStage<Map<String, V>> getBulk(Function<Set<String>, Map<String, V>> factory, Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return new HashMap();
            }
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            Map existingValues = (Map)VCacheUtils.join(this.getBulk(internalKeys));
            Map<String, Object> grandResult = existingValues.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Optional)e.getValue()).get()));
            if (grandResult.size() == existingValues.size()) {
                return grandResult;
            }
            Set missingInternalKeys = existingValues.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).collect(Collectors.toSet());
            Map missingValues = (Map)factory.apply(missingInternalKeys);
            missingValues.entrySet().forEach(e -> {
                if (this.serviceSettings.isAvoidCasOps()) {
                    this.delegate.put((Object)cacheContext.externalEntryKeyFor((String)e.getKey()), (Object)IdentifiedUtils.marshall(e.getValue(), this.valueMarshaller));
                    grandResult.put((String)e.getKey(), e.getValue());
                } else {
                    Optional existing = IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)this.delegate.putIfAbsent((Object)cacheContext.externalEntryKeyFor((String)e.getKey()), (Object)IdentifiedUtils.marshall(e.getValue(), this.valueMarshaller))), this.valueMarshaller);
                    grandResult.put((String)e.getKey(), existing.orElse(e.getValue()));
                }
            });
            return grandResult;
        });
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<IdentifiedValue<V>>>> getBulkIdentified(Iterable<String> internalKeys) {
        return this.perform(() -> {
            this.verifyCasOpsSupported();
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return new HashMap();
            }
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            return StreamSupport.stream(internalKeys.spliterator(), false).distinct().collect(Collectors.toMap(Objects::requireNonNull, k -> IdentifiedUtils.unmarshallIdentified((IdentifiedData)((IdentifiedData)this.delegate.get((Object)cacheContext.externalEntryKeyFor(k))), this.valueMarshaller)));
        });
    }

    @Nonnull
    public CompletionStage<Boolean> put(String internalKey, V value, PutPolicy policy) {
        return this.perform(() -> {
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            String externalKey = cacheContext.externalEntryKeyFor(internalKey);
            IdentifiedData identifiedData = IdentifiedUtils.marshall((Object)value, this.valueMarshaller);
            return LegacyUtils.directPut(externalKey, identifiedData, policy, this.delegate, this.serviceSettings.isAvoidCasOps());
        });
    }

    @Nonnull
    public CompletionStage<Boolean> removeIf(String internalKey, CasIdentifier casId) {
        return this.perform(() -> {
            this.verifyCasOpsSupported();
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            String externalKey = cacheContext.externalEntryKeyFor(internalKey);
            IdentifiedData existingData = IdentifiedUtils.safeCast((CasIdentifier)casId);
            return this.delegate.remove((Object)externalKey, (Object)existingData);
        });
    }

    @Nonnull
    public CompletionStage<Boolean> replaceIf(String internalKey, CasIdentifier casId, V newValue) {
        return this.perform(() -> {
            this.verifyCasOpsSupported();
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            String externalKey = cacheContext.externalEntryKeyFor(internalKey);
            IdentifiedData existingData = IdentifiedUtils.safeCast((CasIdentifier)casId);
            IdentifiedData newData = IdentifiedUtils.marshall((Object)newValue, this.valueMarshaller);
            return this.delegate.replace((Object)externalKey, (Object)existingData, (Object)newData);
        });
    }

    @Nonnull
    public CompletionStage<Void> remove(Iterable<String> internalKeys) {
        return this.perform(() -> {
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            StreamSupport.stream(internalKeys.spliterator(), false).distinct().map(arg_0 -> cacheContext.externalEntryKeyFor(arg_0)).forEach(arg_0 -> this.delegate.remove(arg_0));
            return null;
        });
    }

    @Nonnull
    public CompletionStage<Void> removeAll() {
        return this.perform(() -> {
            this.delegate.removeAll();
            return null;
        });
    }

    @Nonnull
    protected AbstractExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = this.contextSupplier.get();
        return (AbstractExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.delegate.getName());
            return new UnversionedExternalCacheRequestContext(this.keyGenerator, this.delegate.getName(), () -> ((RequestContext)requestContext).partitionIdentifier());
        });
    }

    @Nonnull
    protected ExternalCacheException mapException(Exception ex) {
        return LegacyUtils.mapException(ex);
    }

    @Nonnull
    protected Logger getLogger() {
        return log;
    }

    private String buildExternalKey(String internalKey) {
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        return cacheContext.externalEntryKeyFor(internalKey);
    }

    private void verifyCasOpsSupported() {
        if (this.serviceSettings.isAvoidCasOps()) {
            throw new UnsupportedOperationException("CAS operations not supported in this configuration");
        }
    }

    private /* synthetic */ IdentifiedData lambda$null$14(Supplier supplier) {
        return IdentifiedUtils.marshall(supplier.get(), this.valueMarshaller);
    }
}

