package com.atlassian.vcache.internal.legacy;

import javax.annotation.Nonnull;

/**
 * Builder for {@link LegacyServiceSettings} instances.
 *
 * @since 1.0
 */
public class LegacyServiceSettingsBuilder {
    private boolean avoidCasOps;
    private boolean serializationHack;

    /**
     * Returns a new {@link LegacyServiceSettings} instance configured using the supplied settings.
     *
     * @return a new {@link LegacyServiceSettings} instance configured using the supplied settings.
     */
    @Nonnull
    public LegacyServiceSettings build() {
        return new LegacyServiceSettings(avoidCasOps, serializationHack);
    }

    /**
     * Enable avoiding the use of <tt>CAS-style</tt> operations. Really, really do not turn this setting on.
     */
    public LegacyServiceSettingsBuilder enableAvoidCasOperations() {
        avoidCasOps = true;
        return this;
    }

    /**
     * Enable the serialization hack, whereby if an {@link com.atlassian.vcache.ExternalCache}'s values are
     * {@link java.io.Serializable}, then the values are not marshalled before they are passed to the delegate
     * Atlassian Cache. This is to allow for performance optimisations.
     */
    public LegacyServiceSettingsBuilder enableSerializationHack() {
        serializationHack = true;
        return this;
    }
}
