/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.Sha1ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.atlassian.vcache.internal.core.service.GuavaJvmCache;
import com.atlassian.vcache.internal.guava.GuavaDirectExternalCache;
import com.atlassian.vcache.internal.guava.GuavaServiceSettings;
import com.atlassian.vcache.internal.guava.GuavaStableReadExternalCache;
import com.atlassian.vcache.internal.guava.GuavaTransactionalExternalCache;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.google.common.cache.Cache;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaVCacheService
extends AbstractVCacheService {
    private static final Logger log = LoggerFactory.getLogger(GuavaVCacheService.class);
    private final GuavaServiceSettings serviceSettings;
    private final Map<String, Cache> delegatedCaches = new ConcurrentHashMap<String, Cache>();

    public GuavaVCacheService(String productIdentifier, Supplier<RequestContext> threadLocalContextSupplier, Supplier<RequestContext> workContextContextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, GuavaServiceSettings serviceSettings, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        super(threadLocalContextSupplier, workContextContextSupplier, defaultsProvider, creationHandler, metricsCollector, (ExternalCacheKeyGenerator)new Sha1ExternalCacheKeyGenerator(productIdentifier), begunTransactionalActivityHandler, serviceSettings.getLockTimeout());
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    public GuavaVCacheService(Supplier<RequestContext> threadLocalContextSupplier, Supplier<RequestContext> workContextContextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, ExternalCacheKeyGenerator externalCacheKeyGenerator, GuavaServiceSettings serviceSettings, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        super(threadLocalContextSupplier, workContextContextSupplier, defaultsProvider, creationHandler, metricsCollector, externalCacheKeyGenerator, begunTransactionalActivityHandler, serviceSettings.getLockTimeout());
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    protected Logger log() {
        return log;
    }

    protected <K, V> JvmCache<K, V> createJvmCache(String name, JvmCacheSettings settings) {
        return new GuavaJvmCache(name, settings, this.lockTimeout);
    }

    protected <V> TransactionalExternalCache<V> createTransactionalExternalCache(String name, ExternalCacheSettings settings, MarshallingPair<V> valueMarshalling, boolean valueSerializable) {
        return new GuavaTransactionalExternalCache<V>(name, this.obtainDelegate(name, settings), this.threadLocalContextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshalling), this.transactionControlManager, (MetricsRecorder)this.metricsCollector, this.serviceSettings.getLockTimeout());
    }

    protected <V> StableReadExternalCache<V> createStableReadExternalCache(String name, ExternalCacheSettings settings, MarshallingPair<V> valueMarshalling, boolean valueSerializable) {
        return new GuavaStableReadExternalCache<V>(name, this.obtainDelegate(name, settings), this.workContextContextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshalling), (MetricsRecorder)this.metricsCollector, this.serviceSettings.getLockTimeout());
    }

    protected <V> DirectExternalCache<V> createDirectExternalCache(String name, ExternalCacheSettings settings, MarshallingPair<V> valueMarshalling, boolean valueSerializable) {
        return new GuavaDirectExternalCache<V>(name, this.obtainDelegate(name, settings), this.workContextContextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshalling), this.serviceSettings.getLockTimeout());
    }

    private <V> Cache<String, V> obtainDelegate(String name, ExternalCacheSettings settings) {
        return this.delegatedCaches.computeIfAbsent(name, k -> GuavaUtils.buildDelegate(settings));
    }
}

