package com.atlassian.vcache.internal.guava;

import java.time.Duration;

import static java.util.Objects.requireNonNull;

/**
 * Builder for {@link GuavaServiceSettings} instances.
 *
 * @since 1.0
 */
public class GuavaServiceSettingsBuilder {
    private boolean serializationHack;
    @SuppressWarnings("checkstyle:MagicNumber")
    private Duration lockTimeout = Duration.ofSeconds(30);

    /**
     * Returns a new {@link GuavaServiceSettings} instance configured using the supplied settings.
     *
     * @return a new {@link GuavaServiceSettings} instance configured using the supplied settings.
     */
    public GuavaServiceSettings build() {
        return new GuavaServiceSettings(serializationHack, lockTimeout);
    }

    /**
     * Enable the serialization hack, whereby if an {@link com.atlassian.vcache.ExternalCache}'s values are
     * {@link java.io.Serializable}, then the values are not marshalled before they are passed to the delegate
     * Guava Cache. This is to allow for performance optimisations.
     */
    public GuavaServiceSettingsBuilder enableSerializationHack() {
        serializationHack = true;
        return this;
    }

    /**
     * Change the timeout that is used when acquiring locks.
     * @param lockTimeout the timeout that is used when acquiring locks.
     * @return the current builder
     */
    public GuavaServiceSettingsBuilder lockTimeout(Duration lockTimeout) {
        this.lockTimeout = requireNonNull(lockTimeout);
        return this;
    }
}
