package com.atlassian.vcache.internal.guava;

import java.time.Duration;

import static java.util.Objects.requireNonNull;

/**
 * Represents the settings for the Guava service.
 *
 * @since 1.0
 */
public class GuavaServiceSettings {
    private final boolean serializationHack;
    private final Duration lockTimeout;

    GuavaServiceSettings(boolean serializationHack, Duration lockTimeout) {
        this.serializationHack = serializationHack;
        this.lockTimeout = requireNonNull(lockTimeout);
    }

    public boolean isSerializationHack() {
        return serializationHack;
    }

    public Duration getLockTimeout() {
        return lockTimeout;
    }
}
