package com.atlassian.vcache.internal.guava;

import javax.annotation.Nonnull;

/**
 * Builder for {@link GuavaServiceSettings} instances.
 *
 * @since 1.0
 */
public class GuavaServiceSettingsBuilder {
    private boolean serializationHack;

    /**
     * Returns a new {@link GuavaServiceSettings} instance configured using the supplied settings.
     *
     * @return a new {@link GuavaServiceSettings} instance configured using the supplied settings.
     */
    @Nonnull
    public GuavaServiceSettings build() {
        return new GuavaServiceSettings(serializationHack);
    }

    /**
     * Enable the serialization hack, whereby if an {@link com.atlassian.vcache.ExternalCache}'s values are
     * {@link java.io.Serializable}, then the values are not marshalled before they are passed to the delegate
     * Guava Cache. This is to allow for performance optimisations.
     */
    public GuavaServiceSettingsBuilder enableSerializationHack() {
        serializationHack = true;
        return this;
    }
}
