/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.TransactionControl;
import com.atlassian.vcache.internal.core.TransactionControlManager;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractTransactionalExternalCache;
import com.atlassian.vcache.internal.core.service.UnversionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.google.common.cache.Cache;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaTransactionalExternalCache<V>
extends AbstractTransactionalExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(GuavaTransactionalExternalCache.class);
    private final Cache<String, IdentifiedData> delegate;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Optional<MarshallingPair<V>> valueMarshalling;
    private final TransactionControlManager transactionControlManager;

    public GuavaTransactionalExternalCache(String name, Cache<String, IdentifiedData> delegate, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, Optional<MarshallingPair<V>> valueMarshalling, TransactionControlManager transactionControlManager, MetricsRecorder metricsRecorder, Duration lockTimeout) {
        super(name, contextSupplier, metricsRecorder, lockTimeout, (n, ex) -> {});
        this.delegate = Objects.requireNonNull(delegate);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshalling = Objects.requireNonNull(valueMarshalling);
        this.transactionControlManager = Objects.requireNonNull(transactionControlManager);
    }

    public void transactionSync() {
        log.trace("Cache {}: synchronising operations", (Object)this.name);
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        if (cacheContext.hasRemoveAll()) {
            this.delegate.asMap().clear();
        }
        this.performKeyedOperations(cacheContext);
        cacheContext.forgetAll();
    }

    protected AbstractExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = (RequestContext)this.contextSupplier.get();
        this.transactionControlManager.registerTransactionalExternalCache(requestContext, this.name, (TransactionControl)this);
        return (AbstractExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            return new UnversionedExternalCacheRequestContext(this.keyGenerator, this.getName(), () -> ((RequestContext)requestContext).partitionIdentifier(), this.lockTimeout);
        });
    }

    protected Logger getLogger() {
        return log;
    }

    protected final ExternalCacheException mapException(Exception ex) {
        return GuavaUtils.mapException(ex);
    }

    protected final Optional<V> directGet(String externalKey) {
        return IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)this.delegate.getIfPresent((Object)externalKey)), this.valueMarshalling);
    }

    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return GuavaUtils.directGetBulk(externalKeys, this.delegate, this.valueMarshalling);
    }

    private void performKeyedOperations(AbstractExternalCacheRequestContext<V> cacheContext) {
        try {
            for (Map.Entry entry : cacheContext.getKeyedOperations()) {
                String externalKey = cacheContext.externalEntryKeyFor((String)entry.getKey());
                if (((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).isRemove()) {
                    log.trace("Cache {}: performing remove on entry {}", (Object)this.name, entry.getKey());
                    this.delegate.asMap().remove(externalKey);
                    continue;
                }
                log.trace("Cache {}: performing {} on entry {}", new Object[]{this.name, ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), entry.getKey()});
                IdentifiedData identifiedData = IdentifiedUtils.marshall((Object)((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getValue(), this.valueMarshalling);
                boolean putOutcome = GuavaUtils.directPut(externalKey, identifiedData, ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), this.delegate);
                if (putOutcome) continue;
                log.debug("Cache {}: Unable to perform put() operation {} on entry {}", new Object[]{this.name, ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), entry.getKey()});
                this.delegate.asMap().clear();
                break;
            }
        }
        catch (ExternalCacheException bugger) {
            log.error("Cache {}: an operation failed in transaction sync, so clearing the cache", (Object)this.name);
            this.delegate.asMap().clear();
        }
    }
}

