/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractStableReadExternalCache;
import com.atlassian.vcache.internal.core.service.UnversionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.google.common.cache.Cache;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaStableReadExternalCache<V>
extends AbstractStableReadExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(GuavaStableReadExternalCache.class);
    private final Cache<String, IdentifiedData> delegate;
    private final Supplier<RequestContext> contextSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Optional<MarshallingPair<V>> valueMarshalling;

    public GuavaStableReadExternalCache(String name, Cache<String, IdentifiedData> delegate, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, Optional<MarshallingPair<V>> valueMarshalling, MetricsRecorder metricsRecorder, Duration lockTimeout) {
        super(name, metricsRecorder, lockTimeout, (n, ex) -> {});
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshalling = Objects.requireNonNull(valueMarshalling);
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected boolean internalPut(String internalKey, V value, PutPolicy policy) {
        IdentifiedData identifiedData = IdentifiedUtils.marshall(value, this.valueMarshalling);
        String externalKey = this.ensureCacheContext().externalEntryKeyFor(internalKey);
        return GuavaUtils.directPut(externalKey, identifiedData, policy, this.delegate);
    }

    protected void internalRemove(Iterable<String> internalKeys) {
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        for (String key : internalKeys) {
            this.delegate.asMap().remove(cacheContext.externalEntryKeyFor(key));
            cacheContext.recordValue(key, Optional.empty());
        }
    }

    protected void internalRemoveAll() {
        this.delegate.asMap().clear();
    }

    protected Logger getLogger() {
        return log;
    }

    protected AbstractExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = this.contextSupplier.get();
        return (AbstractExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.getName());
            return new UnversionedExternalCacheRequestContext(this.keyGenerator, this.getName(), () -> ((RequestContext)requestContext).partitionIdentifier(), this.lockTimeout);
        });
    }

    protected V handleCreation(String internalKey, V candidateValue) throws ExecutionException, InterruptedException {
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        IdentifiedData candidateIdentifiedData = IdentifiedUtils.marshall(candidateValue, this.valueMarshalling);
        String externalKey = cacheContext.externalEntryKeyFor(internalKey);
        this.metricsRecorder.record(this.name, CacheType.EXTERNAL, MetricLabel.NUMBER_OF_REMOTE_GET, 1L);
        Optional otherAddedValue = IdentifiedUtils.unmarshall((IdentifiedData)this.delegate.asMap().putIfAbsent(externalKey, candidateIdentifiedData), this.valueMarshalling);
        if (otherAddedValue.isPresent()) {
            this.getLogger().info("Cache {}, unable to add candidate for key {}, use what was added", (Object)this.name, (Object)internalKey);
            this.metricsRecorder.record(this.name, CacheType.EXTERNAL, MetricLabel.NUMBER_OF_REMOTE_GET, 1L);
            return (V)otherAddedValue.get();
        }
        return candidateValue;
    }

    protected final ExternalCacheException mapException(Exception ex) {
        return GuavaUtils.mapException(ex);
    }

    protected final Optional<V> directGet(String externalKey) {
        return IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)this.delegate.getIfPresent((Object)externalKey)), this.valueMarshalling);
    }

    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return GuavaUtils.directGetBulk(externalKeys, this.delegate, this.valueMarshalling);
    }
}

