/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class GuavaUtils {
    static boolean directPut(String externalKey, IdentifiedData identifiedData, PutPolicy policy, Cache<String, IdentifiedData> delegate) {
        switch (policy) {
            case ADD_ONLY: {
                return delegate.asMap().putIfAbsent(externalKey, identifiedData) == null;
            }
            case PUT_ALWAYS: {
                delegate.put((Object)externalKey, (Object)identifiedData);
                return true;
            }
            case REPLACE_ONLY: {
                IdentifiedData existingData = (IdentifiedData)delegate.getIfPresent((Object)externalKey);
                return existingData != null && delegate.asMap().replace(externalKey, existingData, identifiedData);
            }
        }
        throw new IllegalArgumentException("Unknown put policy: " + policy);
    }

    static ExternalCacheException mapException(Exception ex) {
        return new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, (Throwable)ex);
    }

    static <V> Map<String, Optional<V>> directGetBulk(Set<String> externalKeys, Cache<String, IdentifiedData> delegate, Optional<MarshallingPair<V>> valueMarshalling) {
        return StreamSupport.stream(externalKeys.spliterator(), false).distinct().collect(Collectors.toMap(Objects::requireNonNull, k -> IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)delegate.getIfPresent(k)), (Optional)valueMarshalling)));
    }

    public static Cache<String, IdentifiedData> buildDelegate(ExternalCacheSettings settings) {
        return CacheBuilder.newBuilder().maximumSize((long)((Integer)settings.getEntryCountHint().get()).intValue()).expireAfterWrite(((Duration)settings.getDefaultTtl().get()).toMillis(), TimeUnit.MILLISECONDS).build();
    }
}

