package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.RequestCache;

/**
 * Wrapper for a {@link RequestCache} that records metrics.
 *
 * @param <K> the key type
 * @param <V> the value type
 * @since 1.0.0
 */
class TimedRequestCache<K, V>
        extends TimedLocalCacheOperations<K, V>
        implements RequestCache<K, V> {
    private final RequestCache<K, V> delegate;

    TimedRequestCache(RequestCache<K, V> delegate, MetricsRecorder metricsRecorder) {
        super(delegate.getName(), CacheType.REQUEST, metricsRecorder);
        this.delegate = delegate;
    }

    @Override
    protected RequestCache<K, V> getDelegate() {
        return delegate;
    }

    @Override
    public String getName() {
        return delegate.getName();
    }
}
